#!/usr/bin/env python3
import requests,json

data_dictionary = {"id": "0123456789"}
headers = {"Content-Type" : "application/json","Accept":"application/json"}
response = requests.post("http://httpbin.org/post", data = data_dictionary, headers = headers, json = data_dictionary)
print("Kod stanu: " + str(response.status_code))
print(response.headers)
if response.status_code == 200:
    results = response.json()
    for result in results.items():
        print(result)
    print("Nagłówki odpowiedzi:")
    for header, value in response.headers.items():
        print(header, '-->', value)
    print("Nagłówki zapytania:")
    for header, value in response.request.headers.items():
        print(header, '-->', value)
    print("Serwer: " + response.headers['server'])
else:
    print("Kod błędu: %s" % response.status_code)