#!/usr/bin/env python
import subprocess
import sys
import argparse

parser = argparse.ArgumentParser(description='Ping Scan Network')

# Parametry
parser.add_argument("-network", dest="network", help="Podsieć (np. 192.168.56)", required=True)
parser.add_argument("-machines", dest="machines", help="Liczba komputerów", type=int, required=True)

parsed_args = parser.parse_args()

for ip in range(1, parsed_args.machines+1):
    ipAddress = parsed_args.network + '.' + str(ip)
    print("Liczba skanowanych adresów: %s" %(ipAddress))
    if sys.platform.startswith('linux'):
        # Linux
        output = subprocess.Popen(['/bin/ping','-c 1', ipAddress],
                 stdout=subprocess.PIPE).communicate()[0]
    elif sys.platform.startswith('win'):
        # Windows
        output = subprocess.Popen(['ping', ipAddress], stdin=subprocess.PIPE, 
                 stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0]
    output = output.decode('utf-8')
    print("Wynik:", output)
    if "Lost = 0" in output or "bytes from " in output:
        print("Adres %s odpowiedział komunikatem Echo Reply!" % ipAddress)
