import uuid
import hashlib

def hash_password(password):
    # Do wygenerowania liczby losowej jest wykorzystany moduł uuid.
    salt = uuid.uuid4().hex
    return hashlib.sha256(salt.encode() + password.encode()).hexdigest() + ':' + salt

def check_password(hashed_password, user_password):
    password, salt = hashed_password.split(':')
    return password == hashlib.sha256(salt.encode() + user_password.encode()).hexdigest()

new_pass = input('Poodaj hasło: ')
hashed_password = hash_password(new_pass)
print('Skrót hasła: ', hashed_password)
old_pass = input('Podaj ponownie hasło w celu weryfikacji: ')
if check_password(hashed_password, old_pass):
    print("Hasło poprawne")
else:
    print("Hasło błędne")