import os
from cryptography.hazmat.primitives.ciphers import Cipher, algorithms, modes
from cryptography.hazmat.backends import default_backend

backend = default_backend()
key = os.urandom(32)
iv = os.urandom(16)
cipher = Cipher(algorithms.AES(key), modes.CBC(iv), backend = backend)
encryptor = cipher.encryptor()
print(encryptor)
message_encrypted = encryptor.update("Poufny komunikat".encode("utf8"))
print("Zaszyfrowany komunikat:", str(message_encrypted))
cipher_text = message_encrypted + encryptor.finalize()
decryptor = cipher.decryptor()
print("Odszyfrowany komunikat:", str(decryptor.update(cipher_text).decode()))