import nmap, sys

command = "system_operacyjny.py <nazwa lub adres IP hosta>"
if len(sys.argv) == 1:
    print(command)
    sys.exit()
host = sys.argv[1]
portScanner = nmap.PortScanner()
open_ports_dict =  portScanner.scan(host, arguments = "-O -v")
if open_ports_dict is not None:
    open_ports_dict = open_ports_dict.get("scan").get(host).get("tcp")
    print("Port\tOpis")
    port_list = open_ports_dict.keys()
    for port in port_list:
        print(port, "\t", open_ports_dict.get(port)['name'])
    print("\n--------------Informacje o systemie opeacyjnym---------------------\n")
    print("Skanowany host:", portScanner[host]['osmatch'][0]['osclass'][0]['cpe'])
    print("Rodzina systemu operacyjnego:", portScanner[host]['osmatch'][0]['osclass'][0]['osfamily'])
    print("Typ systemu operacyjnego:", portScanner[host]['osmatch'][0]['osclass'][0]['type']) 
    print("Wersja systemu operacyjnego:", portScanner[host]['osmatch'][0]['osclass'][0]['osgen'])
    print("Producent systemu operacyjnego:", portScanner[host]['osmatch'][0]['osclass'][0]['vendor'])
    print("Dokładność analizy:", portScanner[host]['osmatch'][0]['osclass'][0]['accuracy'])