#!/usr/bin/env python
import argparse
import dns.name

def main(domain1, domain2):
    d1 = dns.name.from_text(domain1)
    d2 = dns.name.from_text(domain2)
    print(f"{domain1} jest poddomeną {domain2}:", d1.is_subdomain(d2)) 
    print(f"{domain1} jest naddomeną {domain2}:", d1.is_superdomain(d2))

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description = 'Sprawdzenie poddomeny')
    parser.add_argument('--domain1', action = 'store', dest = 'domain1', default = 'python.org')
    parser.add_argument('--domain2', action = 'store', dest = 'domain2', default = 'docs.python.org')
    given_args = parser.parse_args() 
    domain1 = given_args.domain1
    domain2 = given_args.domain2
    main(domain1, domain2)