inline void scanForInjection() __attribute__((always_inline));

void scanForInjection()
{
  uint32_t count = _dyld_image_count();
  char* evilLibs[] =
  {
    "Substrate", "cycript"
  };
  
  for(uint32_t i = 0; i < count; i++)
  {
    const char *dyld = _dyld_get_image_name(i);
    int slength = strlen(dyld);
    int j;
    
    for(j = slength - 1; j>= 0; --j)
      if(dyld[j] == '/') break;
    
    char *name = strndup(dyld + ++j, slength - j);
    for(int x=0; x < sizeof(evilLibs) / sizeof(char*); x++)
    {
      if(strstr(name, evilLibs[x]) || strstr(dyld, evilLibs[x])) fprintf(stderr,"Found injected library matching string: %s", evilLibs[x]);
    }
    free(name);
  }
}