package com.wakaleo.bddinaction.chapter9.flightstatus.steps;

import com.wakaleo.bddinaction.chapter9.flightstatus.client.FlightStatusClient;
import com.wakaleo.bddinaction.chapter9.flightstatus.client.JerseyFlightStatusClient;
import com.wakaleo.bddinaction.chapter9.flightstatus.model.Flight;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

import static com.google.common.collect.Lists.newArrayList;

public class FlightDetailsSteps {

    String flightNumber;
    Flight matchingFlight;
    FlightStatusClient client = new JerseyFlightStatusClient();

    @Given("^chcę poznać szczegóły lotu numer (.*)$")
    public void the_flight_number(String flightNumber) throws Throwable {
        this.flightNumber = flightNumber;
    }

    @When("^poproszę o szczegóły tego lotu$")
    public void I_request_the_details_about_this_flight() throws Throwable {
        matchingFlight = client.findByFlightNumber(flightNumber);
    }

    @Then("^powinienem otrzymać następujące informacje:$")
    public void I_should_receive_the_following_details(DataTable flightDetails) throws Throwable {
        flightDetails.diff(newArrayList(matchingFlight));
    }

String receivedJsonData;

@When("^poproszę o szczegóły tego lotu w formacie JSON$")
public void request_details_in_json_format() {
    receivedJsonData = client.findByFlightNumberInJson(flightNumber);
}

@Then("^powinienem otrzymać:$")
public void should_receive_json_data(String expectedJsonData) throws JSONException {
    JSONAssert.assertEquals(expectedJsonData, receivedJsonData, JSONCompareMode.LENIENT);
}

}

