package com.bddinaction.chapter8.jbehave.steps;

import com.bddinaction.chapter8.jbehave.model.DestinationDeal;
import com.bddinaction.chapter8.jbehave.pages.HomePage;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Then;

import java.util.List;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.fest.assertions.api.Assertions.assertThat;

/**
 * Tutaj opis.
 * Użytkownik: janusz
 * Data: 6/10/13
 * Godzina: 9:13 PM
 */
public class FeaturedDestinationSteps {

    HomePage homePage;

    @Then("powinna zobaczyć $featuredCount polecane miejsca docelowe")
    @Alias("powinien zobaczyć $featuredCount polecane miejsca docelowe")
    public void shouldSeeFeaturedDestinations(int featuredCount) {
        assertThat(homePage.getFeaturedDestinations().size()).isEqualTo(featuredCount);
    }

    @Then("wśród polecanych celów powinien się znaleźć $expectedDestination za cenę $price")
    public void featuredDestinationsShouldInclude(String expectedDestination, int price) {
        DestinationDeal expectedDeal = new DestinationDeal(expectedDestination, price);
        assertThat(homePage.getFeaturedDestinations()).contains(expectedDeal);
    }
}

