package com.bddinaction.chapter8.jbehave;

import net.thucydides.jbehave.ThucydidesJUnitStories;
import net.thucydides.jbehave.UTF8StoryLoader;

import java.util.Locale;

import org.jbehave.core.Embeddable;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.parsers.RegexStoryParser;


public class AcceptanceTestSuite extends ThucydidesJUnitStories {

private final Locale DEFAULTSTORYLANGUAGE = new Locale("pl");	
public Configuration configuration() {
        Configuration configuration = super.configuration();
        Class<? extends Embeddable> embeddableClass = this.getClass();
        Keywords keywords = new LocalizedKeywords(DEFAULTSTORYLANGUAGE);
        configuration.useKeywords(keywords)
            .useStoryParser(new RegexStoryParser(keywords))
                .useStoryLoader(new UTF8StoryLoader())
                .storyReporterBuilder().withKeywords(keywords);
        return  configuration;
    }  
    
}


