package com.bddinaction.chapter7.steps;

import com.bddinaction.chapter7.model.Persona;
import com.bddinaction.chapter7.model.Status;
import static com.bddinaction.chapter7.model.Status.NieJestUczestnikiem;

import com.bddinaction.chapter7.steps.thucydides.EmailSteps;
import com.bddinaction.chapter7.steps.thucydides.NewMemberSteps;
import net.thucydides.core.annotations.Steps;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;


public class ScenariuszRejestracji {

    @Steps
    NewMemberSteps newMember;

    Persona persona;

    @Given("$persona nie jest uczestnikiem programu Frequent Flyer")
    public void givenANonFrequentFlyerMember(String name) {
        persona = Persona.withName(name);
        persona.setStatus(NieJestUczestnikiem);
        persona.save();
    }

    @Given("$nazwa jest uczestnikiem programu Frequent Flyer o statusie $status")
    public void givenAFrequentFlyerMemberWithStatus(String name, Status status) {
        persona = Persona.withName(name);
        persona.setStatus(status);
    }

    @When("$name zarejestruje się w systemie w celu uzyskania nowego konta")
    public void whenAUserRegistersForANewAccount(String name) {
        newMember.opensFrequentFlyerSite();
        newMember.choosesToRegister();
        newMember.entersNameAndAddress(persona);
        newMember.submitsApplication();
    }

    @Steps
    EmailSteps email;

    @Then("do $name powinien być wysłany e-mail z potwierdzeniem zawierający jej numer konta")
    public void shouldReceiveConfirmationEmailWithAccountNumber(String name) {
//        List<EmailMessage> emails = email.getEmailsForUser(name);
//        assertThat(emails, containsMessageWithTitle("Witaj w klubie Flying High Club"));
    }

    @Then("Janina powinna uzyskać $bonusPoints punktów premii")
    public void thenJaneShouldReceiveBonusPoints(int bonusPoints) {
        // PENDING
    }
}

