package com.bddinaction.chapter12.model;

public enum FrequentFlyerStatus {

    BRĄZOWY(0), SREBRNY(300), ZŁOTY(700), PLATYNOWY(1500);

    private final int minimumPoints;

    FrequentFlyerStatus(int minimumPoints) {
        this.minimumPoints = minimumPoints;
    }

    public static FrequentFlyerStatus statusLevelFor(int statusPoints) {
        FrequentFlyerStatus highestMatchingStatus = BRĄZOWY;
        for(FrequentFlyerStatus status : FrequentFlyerStatus.values())  {
            if (statusPoints >= status.minimumPoints) {
                highestMatchingStatus = status;
            }
        }
        return highestMatchingStatus;
    }
}
