'use strict';

describe('Frequent Flyers', function() {

    var FrequentFlyer = require('../lib/frequent_flyer');
    var frequentFlyer;
    var expect = require('chai').expect

    beforeEach(function() {
        frequentFlyer = new FrequentFlyer();
    });


    describe("Zarządzanie statusami Frequent Flyer", function() {
        it("powinen mieć początkowy status Brązowy", function() {
            expect(frequentFlyer.getStatus()).to.equal('Brązowy');
        });

        it("powinien początkowo nie mieć punktów statusowych", function() {
            expect(frequentFlyer.getStatusPoints()).to.equal(0);
        });

    });

    describe("Zbieranie punktów Frequent Flyer", function() {
       it('powinien zdobywać punkty za każdy lot', function() {

           frequentFlyer.earnStatusPoints(100);
           frequentFlyer.earnStatusPoints(50);

           expect(frequentFlyer.getStatusPoints()).to.equal(150);
       });

        it('powinien aktualizować status uczestnika po zdobyciu wystarczającej liczby punktów', function() {

            frequentFlyer.earnStatusPoints(300);

            expect(frequentFlyer.getStatus()).to.equal('Srebrny');
        });

        it('powinien coś robić', function() {

            var obtainableStatuses = ['Srebrny','Złoty','Platynowy']

            expect(obtainableStatuses).to.have.length(3).and.to.include('Złoty')
        });
    });
});

