package com.bddinaction.chapter8.jbehave.steps;

import com.bddinaction.chapter8.jbehave.flowsteps.AuthenticationFlowSteps;
import com.bddinaction.chapter8.jbehave.model.FrequentFlyerMember;
import net.thucydides.core.annotations.Steps;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;

public class UserAuthenticationSteps {

    @Steps
    private AuthenticationFlowSteps registeredMember;

    @Given("$user jest zarejestrowanym uczestnikiem programu Frequent Flyer")
    public void givenARegisteredFrequentFlyer(FrequentFlyerMember user) {}

    @When("$user przeprowadzi uwierzytelnianie przesyłając prawidłowy adres e-mail i hasło")
    public void whenJaneAuthenticatesWithAValidEmailAddressAndPassword(FrequentFlyerMember user) {
        registeredMember.enterEmailAndPasswordFor(user);
    }

    @Then("$user powinna uzyskać dostęp do swojego konta")
    @Alias("$user powinien uzyskać dostęp do swojego konta")
    public void thenTheUserShouldBeGivenAccessToAccount(FrequentFlyerMember user) {
        registeredMember.verifyWelcomeMessageFor(user);
    }

    @Given("$user zalogował się")
    public void aUserHasLoggedOnAs(FrequentFlyerMember user) {
        registeredMember.enterEmailAndPasswordFor(user);
    }

    @When("$user przegląda stronę główną")
    public void whenAUserViewsTheHomePage() {}

}

