package com.bddinaction.chapter8.jbehave.steps;

import com.bddinaction.chapter8.jbehave.flowsteps.TravellerFlowSteps;
import com.bddinaction.chapter8.jbehave.pages.BookingPage;
import net.thucydides.core.annotations.Steps;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.openqa.selenium.support.ui.WebDriverWait;

import java.util.List;

import static org.fest.assertions.api.Assertions.assertThat;

public class BookingAFlightSteps {

    @Steps
    TravellerFlowSteps traveller;

    @Given("chcę zarezerwować lot")
    public void givenIWantToBookAFlight() {
        traveller.navigateToFlightBookings();
    }

    @When("poszukuję lotów $flightType z $from do $to w klasie $travelClass")
    public void whenISearchForFlights(String flightType, String from, String to, String travelClass) {
        traveller.searchForFlights(flightType, from, to, travelClass);
    }

    @Then("powinienem zobaczyć listę wszystkich dostępnych lotów")
    public void thenIShouldSeeTheListOfAllAvailableFlights() {
    }

    BookingPage bookingPage;

    @When("wpiszę '$prefix' w polu 'miasto startu'")
    public void enterFromPrefix(String prefix) {
        bookingPage.setFrom(prefix);
    }

    @Then("powinienem otrzymać informacje o następujących miastach: $expectedCities")
    public void shouldSeeCities(List<String> expectedCities) {
        assertThat(bookingPage.getFromTypeaheads()).containsAll(expectedCities)
                                                   .hasSize(expectedCities.size());

    }

}

