package com.bddinaction.chapter10.model;

import com.bddinaction.chapter10.services.InMemoryStatusService;
import com.bddinaction.chapter10.services.StatusService;
import org.junit.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class WhenCheckingStatusPointUpgrades {


    StatusService statusService = new InMemoryStatusService();

    @Test
    public void should_stay_on_bronze_for_zero_points() {
        assertThat(statusService.statusLevelFor(0), is(Status.Brazowy));
    }

    @Test
    public void should_stay_on_bronze() {
        assertThat(statusService.statusLevelFor(299), is(Status.Brazowy));
    }

    @Test
    public void should_earn_silver() {
        assertThat(statusService.statusLevelFor(300), is(Status.Srebrny));
    }

    @Test
    public void should_stay_on_silver() {
        assertThat(statusService.statusLevelFor(699), is(Status.Srebrny));
    }

    @Test
    public void should_earn_gold() {
        assertThat(statusService.statusLevelFor(700), is(Status.Zloty));
    }

    @Test
    public void should_cumulate_points_with_each_flight() {

        // ZAKŁADAJĄC
        StatusService statusService = mock(StatusService.class);
        when(statusService.statusLevelFor(300)).thenReturn(Status.Srebrny);

        FrequentFlyer member = new FrequentFlyer("12345678","Janusz", "Bloger", statusService);

        // GDY
        member.earns(100).statusPoints();
        member.earns(200).statusPoints();

        // WTEDY
        assertThat(member.getStatusPoints(),is(greaterThanOrEqualTo((300))));
        assertThat(member.getStatus(), is(Status.Srebrny));
    }

    @Test
    public void should_see_next_obtainable_statuses() {
        FrequentFlyer member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz", "Bloger");
        assertThat(member.getUnachievedStatuses(), hasItems(Status.Zloty, Status.Platynowy));
    }
}

