package com.bddinaction.chapter10.junit;


import com.bddinaction.chapter10.model.FrequentFlyer;
import com.bddinaction.chapter10.model.Status;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import java.util.Arrays;
import java.util.Collection;

import static com.bddinaction.chapter10.model.Status.Brazowy;
import static com.bddinaction.chapter10.model.Status.Zloty;
import static com.bddinaction.chapter10.model.Status.Platynowy;
import static com.bddinaction.chapter10.model.Status.Srebrny;
import static org.fest.assertions.Assertions.assertThat;

@RunWith(Parameterized.class)
public class WhenEarningStatusLevels {

    @Parameters
    public static Collection pointsPerStatus() {
        return Arrays.asList(new Object[][]{
                {Brazowy, 0, 100, Brazowy},
                {Brazowy, 0, 300, Srebrny},
                {Brazowy, 100, 200, Srebrny},
                {Srebrny, 0, 700, Zloty},
                {Zloty, 0, 1500, Platynowy}
        });
    }

    Status initialStatus, finalStatus;
    int initialPoints, earnedPoints;

    public WhenEarningStatusLevels(Status initialStatus,  int initialPoints,
                                   int earnedPoints, Status finalStatus) {
        this.initialStatus = initialStatus;
        this.initialPoints = initialPoints;
        this.earnedPoints = earnedPoints;
        this.finalStatus = finalStatus;
    }

    @Test
    public void should_earn_new_status_based_on_point_thresholds() {
        FrequentFlyer member = FrequentFlyer.withFrequentFlyerNumber("12345678")
                                            .named("Janusz", "Bloger")
                                            .withStatusPoints(initialPoints)
                                            .withStatus(initialStatus);

        member.earns(earnedPoints).statusPoints();

        assertThat(member.getStatus()).isEqualTo(finalStatus);


    }
}

