package com.bddinaction.chapter10.model

import com.bddinaction.chapter10.services.AirportService
import com.bddinaction.chapter10.services.FrequentFlyerFlightService
import spock.lang.Specification

class WhenRetrievingFlightDetails extends Specification {

    def airportService

    def setup() {
        airportService = Mock(AirportService)
        airportService.findAirportByCode("MEL") >> new Airport("MEL", "Melbourne")
        airportService.findAirportByCode("SYD") >> new Airport("SYD", "Sydney")
    }

    def "Wyszukiwanie szczegółowych danych lotu według numeru"() {
        given: "Chcę poznać szczegóły lotu o numerze FH-101"
            def flightService = new FrequentFlyerFlightService(airportService);
            def flightNumber = "FH-101"
            def airport = "MEL"
        when: "Poproszę o szczegółowe dane o tym locie"
            def flightDetails = flightService.findFlightByNumber(airport, flightNumber);
        then: "Powinienem otrzymać poprawne szczegółowe dane lotu"
            flightDetails.flightNumber == "FH-101" &&
            flightDetails.departure.name == "Melbourne" &&
            flightDetails.departure.code == "MEL" &&
            flightDetails.destination.name == "Sydney" &&
            flightDetails.destination.code == "SYD" &&
            flightDetails.time == "06:00"
    }
}

