package com.bddinaction.chapter10.model

import spock.lang.Specification

import static com.bddinaction.chapter10.model.Status.*

class WhenEarningStatus extends Specification {

    def "powinien uzyskać status na podstawie liczby zdobytych punktów statusowych"() {
        given:
        def member = FrequentFlyer.withFrequentFlyerNumber("12345678")
                .named("Jan", "Jankowski")
                .withStatusPoints(initialPoints)
                .withStatus(initialStatus);

        when:
        member.earns(earnedPoints).statusPoints()

        then:
        member.status == finalStatus

        where:
        initialStatus | initialPoints | earnedPoints | finalStatus
        Brazowy     | 0             | 100          | Brazowy
        Brazowy     | 0             | 300          | Srebrny
        Brazowy     | 100             | 200          | Srebrny
        Srebrny     | 0             | 700          | Zloty
        Zloty         | 0             | 1500         | Platynowy
    }
}

