'use strict';

describe('Frequent Flyers', function() {

    var FrequentFlyer = require('../lib/frequent_flyer');
    var frequentFlyer;
    require('chai').should()

    beforeEach(function() {
        frequentFlyer = new FrequentFlyer();
    });


    describe("Zarządzanie statusami uczestników programu Frequent Flyer", function() {
        it("powinen mieć początkowy status Brązowy", function() {
            frequentFlyer.getStatus().should.equal('Brązowy');
        });

        it("powinien początkowo nie mieć punktów statusowych", function() {
            frequentFlyer.getStatusPoints().should.equal(0);
        });

    });

    describe("Zbieranie punktów Frequent Flyer", function() {
        it('powinien zdobywać punkty za każdy lot', function() {

            frequentFlyer.earnStatusPoints(100);
            frequentFlyer.earnStatusPoints(50);

            frequentFlyer.getStatusPoints().should.equal(150);
        });

        it('powinien aktualizować status uczestnika po zdobyciu wystarczającej liczby punktów', function() {

            frequentFlyer.earnStatusPoints(300);

            frequentFlyer.getStatus().should.equal('Srebrny');
        });

        it('powinien coś robić', function() {

            var obtainableStatuses = ['Srebrny','Złoty','Platynowy']

            obtainableStatuses.should.include('Złoty')
        });

    });
});

