#ifndef __VS1003__
#define __VS1003__

#ifndef ASM
typedef short s_int16;
typedef unsigned short u_int16;
typedef long s_int32;
typedef unsigned long u_int32;

typedef __fract s_int16 f_int16;
typedef __fract s_int32 f_int32;

typedef unsigned char byte;
#endif/*ASM*/

/* AUDIOBUFSIZE = 64, 128, 256, or 512 */
#define		AUDIOBUFSIZE		64

#define         MAX_NAME_SIZE           81
#define         SBLIMIT                 32
#define         SCALE_BLOCK             12
#define         SSLIMIT                 18

#define HYBL_SIZE (2*(SBLIMIT+1)*SSLIMIT)
#ifndef ASM
extern s_int16 hyBlock[2][(SBLIMIT+1)*SSLIMIT];
#endif


/* For Application, general.c/h */

#define APPL_RESET	 0
#define APPL_AUDIO	 1
#define APPL_W0		 2
#define APPL_W1		 3
#define APPL_W2		 4
#define APPL_W3		 5
#define APPL_R0		 6
#define APPL_R1		 7
#define APPL_R2		 8
#define APPL_R3		 9
#define APPL_BITSTREAM	10


#ifndef ASM

extern s_int16 pcm_sample[AUDIOBUFSIZE];
extern s_int16 pcm_point;

/* These may be used by layer 1 and 2 for other purposes.
   Size for each table is 1152. */
extern s_int16 hybridIn[2][SBLIMIT][SSLIMIT];
extern s_int16 hybridOut[2][SSLIMIT][SBLIMIT];

extern s_int16 (*applAddr)(s_int16 register __i0 **d,
			   s_int16 register __a1 mode,
			   s_int16 register __a0 n);
#endif






#define MR_NONE 0
#define MR_INT 0x200
#define MR_SAT 0x400

#define AUDIO_BUFFER_SZ  4096
#define STREAM_BUFFER_SZ 1024

#define STACK_START    0x1880
#define STACK_SIZE     0xc0
#define DEBUG_STACK    0x1920  /* tarvitaan ainakin 18 + temppitilaa */

#define USER_AREA_START 0x1800
#define USER_AREA_SIZE 0x80

#define INT_EN_TIM1 7
#define INT_EN_TIM0 6
#define INT_EN_RX   5
#define INT_EN_TX   4
#define INT_EN_MODU 3
#define INT_EN_SDI  2
#define INT_EN_SCI  1
#define INT_EN_DAC  0

#define INT_EN_NONE 0
#define INT_EN_ALL ((1<<INT_EN_DAC)|(1<<INT_EN_SCI)|(1<<INT_EN_SDI)|(1<<INT_EN_TX)|(1<<INT_EN_RX))

#ifndef ASM
#define USEY(x) (*(volatile u_int16 __y *)(u_int16)(x))
#define USEX(x) (*(volatile u_int16 __x *)(u_int16)(x))
#endif


#define SCI_BASE	0xC000
#define SCI_MODE	0xC000
#define SCI_STATUS	0xC001
#define SCI_BASS	0xC002
#define SCI_CLOCKF	0xC003
#define SCI_DECODE_TIME	0xC004
#define SCI_AUDATA	0xC005
#define SCI_WRAM	0xC006
#define SCI_WRAMADDR	0xC007
#define SCI_HDAT0	0xC008
#define SCI_HDAT1	0xC009
#define SCI_AIADDR	0xC00A
#define SCI_VOL		0xC00B
#define SCI_AICTRL0	0xC00C
#define SCI_AICTRL1	0xC00D
#define SCI_AICTRL2	0xC00E
#define SCI_AICTRL3	0xC00F
#define SCI_CHANGE	0xC010
#define SER_DATA	0xC011	/* R */
#define SER_DREQ	0xC012	/* RW, LSB controls DREQ pin */
#define FREQCTLL	0xC013
#define FREQCTLH	0xC014
#define DAC_LEFT	0xC015
#define DAC_RIGHT	0xC016
#define GPIO_DDR	0xC017
#define GPIO_DATA	0xC018
#define GPIO_ODATA	0xC019
#define INT_ENABLE	0xC01A	/* RW */
#define INT_GLOB_DIS	0xC01B	/* W  */
#define INT_GLOB_ENA	0xC01C	/* W  */
#define INT_COUNTER	0xC01D	/* R  */
#define MODU_DIV	0xC01E
#define MODU_DATA	0xC01F

#define WDOG_CONFIG	0xC020
#define WDOG_RESET	0xC021
#define WDOG_DUMMY	0xC022
#define WDOG_RESET_VAL	0x4ea9

#define UART_STATUS	0xC028
#define UART_DATA	0xC029
#define UART_DATAH	0xC02A
#define UART_DIV	0xC02B

#define TIMER_CONFIG	0xC030
#define TIMER_ENABLE	0xC031
#define TIMER_T0L	0xC034
#define TIMER_T0H	0xC035
#define TIMER_T0CNTL	0xC036
#define TIMER_T0CNTH	0xC037
#define TIMER_T1L	0xC038
#define TIMER_T1H	0xC039
#define TIMER_T1CNTL	0xC03A
#define TIMER_T1CNTH	0xC03B

#define TIMER_EN_T0_B 0
#define TIMER_EN_T1_B 1

#define TIMER_EN_T0 (1<<TIMER_EN_T0_B)
#define TIMER_EN_T1 (1<<TIMER_EN_T1_B)

#define I2S_CONTROL     0xC040
#define I2S_MCLK_ENA 8
#define I2S_TX_ENA   4
#define I2S_48K      0
#define I2S_96K      1
#define I2S_192K     2

#define FUSE_REG        0xC041
#define FUSE_BIT        (1<<5)

/*

  Pin mappings:
  GPIO0 - old TEST1 - e.g. _CS
  GPIO1 - old TEST2 -      MOSI
  GPIO2 - DCLK      -      CLK
  GPIO3 - SDATA     -      MISO

 */

#define SCIMB_DIFFERENTIAL	 0
#define SCIMB_ALLOW_LAYER12	 1
#define SCIMB_SOFT_RESET	 2
#define SCIMB_OUT_OF_WAV	 3
#define SCIMB_POWERDOWN		 4
#define SCIMB_ALLOW_TESTS	 5
#define SCIMB_STREAM_MODE	 6
#define SCIMB_PLUSV		 7
#define SCIMB_DCLK_ACTIVE_EDGE	 8
#define SCIMB_SDI_BYTE_ORDER	 9
#define SCIMB_SDI_SHARED	10
#define SCIMB_SDI_NEWMODE	11
#define SCIMB_ADPCM		12
#define SCIMB_ADPCM_HP		13
#define SCIMB_LINE		14
#define SCIMB_CLK_IN_DIV	15

#define SCIST_MINUS06	0
#define SCIST_MINUS12	1
#define SCIST_APDOWN1	2	/* Analog internal */
#define SCIST_APDOWN2	3	/* Driver */
#define SCIST_VER0	4	/* Version number 0..7 */
#define SCIST_VER1	5	/* Upto VS1001k = 0, VS1011 = 1, VS1002 = 2 */
#define SCIST_VER2	6

#define MODUB_POWERDOWN 15

#define SCIW_OFFSET (SCI_BASE-0x10)

#define UART_ST_RXORUN    (1<<3)
#define UART_ST_RXFULL    (1<<2)
#define UART_ST_TXFULL    (1<<1)
#define UART_ST_TXRUNNING (1<<0)

/*
   defaulttijakaja voisi olla DIV12M38400
	~albert/proj/bamo/romcode/di.c osaa laskea oikeat jakajan arvot
	yhteisjakajasta 5.. (pienemmilla arvoilla d2<6, mika on virhe).
	USEX(UART_DIV) = ((d1-1)<<8) | d2;
*/
#define DIV12M9600  0x1f32 /* 32x40=1280 */
#define DIV12M19200 0x1320 /* 20x32=640 */
#define DIV12M38400 0x0f14 /* 16x20=320 */
#define DIV12M57600 0x0910 /* 10x16=160 */





#define FCH_MUL0_B 4
#define FCH_MUL1_B 5
#define FCH_MUL2_B 6
#define FCH_MUL3_B 7
#define FCH_DIV_INCLK_B 8
#define FCH_FORCE_PLL_B 9
#define FCH_VCO_OUT_ENA_B 11
#define FCH_PLL_SET_LOCK_B 12
#define FCH_PLL_LOCKED_B 13

#define FCH_MUL0 (1<<FCH_MUL0_B)
#define FCH_MUL1 (1<<FCH_MUL1_B)
#define FCH_MUL2 (1<<FCH_MUL2_B)
#define FCH_MUL3 (1<<FCH_MUL3_B)
#define FCH_DIV_INCLK (1<<FCH_DIV_INCLK_B)
#define FCH_FORCE_PLL (1<<FCH_FORCE_PLL_B)
#define FCH_VCO_OUT_ENA (1<<FCH_VCO_OUT_ENA_B)
#define FCH_PLL_SET_LOCK (1<<FCH_PLL_SET_LOCK_B)
#define FCH_PLL_LOCKED (1<<FCH_PLL_LOCKED_B)


#define USER_CODEC_ADDR 0
#define USER_CODEC ((void (*) (void))USER_CODEC_ADDR)

#ifndef ASM

auto void SetHardware(register s_int16 channels, register u_int16 rate);
void SetRate(register __c1 u_int16 rate);
void SetPll(void);
auto void SetVolumeFromSpi(void);
auto void SetClockFromSpi(void);

extern s_int16 __y audio_buffer[];
volatile extern s_int16 __y * audio_wr_pointer;
volatile extern s_int16 __y * audio_rd_pointer;
extern u_int16 stream_buffer[];
volatile extern u_int16 __x * __y stream_wr_pointer;
volatile extern u_int16 __x * __y stream_rd_pointer;
volatile extern s_int16 __y stream_rd_odd;
extern const s_int16 dB[12];

extern __y u_int16 hwSampleRate;
extern u_int16 __y bassOn, trebleOn;
extern s_int16 __y volume[2];

extern s_int16 __y streamMode;
extern s_int16 __y streamModeLastRate;
extern const u_int16 streamModeLimits[16];

extern u_int16 __y dreqAfterSci;

auto u_int16 DataBytes(void);

auto s_int16 AudioBufFill(void);
auto s_int16 StreamDiff(void);

extern u_int16 __y intClock2KHz;

#endif /*!ASM*/


#ifndef ASM
void WriteToProgramRam(register __i0 addr,
		       register __a1 msB, register __a0 lsB);
u_int32 ReadFromProgramRam(register __i0 addr);
auto void Sleep(void);
auto void StereoCopy(register __i2 s_int16 *s, register __a0 u_int16 n);
void Disable(void);	/* NOT auto */
void Enable(void);	/* NOT auto */
#endif/*!ASM*/


#endif /*__VS1003__*/

