/*
 * VS1003B.c
 *
 * Created: 2013-10-31 10:19:08
 *  Author: tmf
 */

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include "VS1003B.h"
#include "SPI.h"
#include "ffconf.h"

uint32_t VS_Buffer_ptr;                    //Wskanik na aktualnie odczytywany bajt w buforze

FIL       sound_file;               //Plik zawierajcy muzyk do odtworzenia

void VS1003_DMA_init();

void SPI_VS_init(uint16_t clk)
{
	VS_PORT.OUTSET=VS_xCS | VS_xDCS | VS_RESET;
	VS_PORT.DIRSET=VS_xDCS | VS_xCS | VS_RESET | VS_TxD | VS_SCK;   //Piny wyjciowe interfejsu
	VS_USART.CTRLC=USART_CMODE_MSPI_gc;             //Master SPI, MSB first, dane prbokwane na zboczu narastajcym

	VS_USART.BAUDCTRLA=F_CPU/clk/1000 - 1;
	VS_USART.BAUDCTRLB=0;

	VS_USART.CTRLB=USART_RXEN_bm | USART_TXEN_bm;   //Odblokuj nadajnik i odbiornik
}

//Zresetuj koprocesor, zwr false, jeli ukad nie odpowiada
_Bool VS1003_Reset()
{
	VS_PORT.OUTCLR=VS_RESET;  //Reset ukadu
	_delay_ms(1);
	VS_PORT.OUTSET=VS_RESET;

	uint8_t del=255;
	while(((VS_PORT.IN & VS_DREQ) == 0) && (del))   //Czekamy na gotowo ukadu
	{
		_delay_us(100);
		del--;
	}
	return (del != 0);     //Zwr false jeli ukad nie odpowiedzia na RESET
}

uint16_t SPI_VS_io_word(uint16_t word)
{
	uint16_t ret=SPI_RW_Byte(&VS_USART, word >> 8) << 8;  //Wylij bardziej znaczcy bajt
	ret+=SPI_RW_Byte(&VS_USART, word & 0xff);             //Wylij mniej znaczcy bajt
	return ret;
}

//Dostp do interfejsu polece VS1003
static inline void VS1003_xCS_Enable(_Bool en)
{
	if(en)
	{
		VS_PORT.OUTSET=VS_xDCS;    //Deaktywuj xDCS
		VS_PORT.OUTCLR=VS_xCS;     //Aktywuj xCS
	} else VS_PORT.OUTSET=VS_xCS;
}

//Dostp do interfejsu danych VS1003
static inline void VS1003_xDCS_Enable(_Bool en)
{
	if(en)
	{
		VS_PORT.OUTSET=VS_xCS;    //Deaktywuj xCS
		VS_PORT.OUTCLR=VS_xDCS;   //Aktywuj xDCS
	} else VS_PORT.OUTSET=VS_xDCS;
}

static inline void VS_1003_DREQ_High()
{
	while((VS_PORT.IN & VS_DREQ) == 0);
}

void VS1003_WriteReg(uint8_t cmd, uint16_t value)
{
	VS1003_xCS_Enable(true);       //Aktywuj DCI
	SPI_RW_Byte(&VS_USART, VS_WRITE_CMD);
	SPI_RW_Byte(&VS_USART, cmd);
	SPI_VS_io_word(value);         //Domylna konfiguracja
	VS1003_xCS_Enable(false);
	VS_1003_DREQ_High();           //Zaczekaj na koniec realizacji polecenia
}

uint16_t VS1003_ReadReg(uint8_t cmd)
{
	while(VS_USART.STATUS & USART_RXCIF_bm) VS_USART.DATA;   //Oprnij bufor odbiornika ze mieci
	VS1003_xCS_Enable(true);       //Aktywuj DCI
	SPI_RW_Byte(&VS_USART, VS_READ_CMD);
	SPI_RW_Byte(&VS_USART, cmd);
	uint16_t ret=SPI_VS_io_word(0);         //Domylna konfiguracja
	VS1003_xCS_Enable(false);
	VS_1003_DREQ_High();           //Zaczekaj na koniec realizacji polecenia
	return ret;
}

_Bool VS1003_init()
{
	SPI_VS_init(2000);                         //Inicjalizacja interfejsu z niskim taktowaniem
	if(VS1003_Reset() == false) return false; //Zresetuj ukad

	VS1003_WriteReg(VS_MODE, *(uint16_t*)&((VS_SCI_MODE){.SM_SDINEW=true}));  //Domylna konfiguracja
	VS1003_WriteReg(VS_BASS, 0x0000);        //Nie uywamy "polepszaczy"
	VS1003_WriteReg(VS_CLOCKF, *(uint16_t*)&((VS_SCI_CLOCKF){.SC_MULT=SC_MULT_XTAL30, .SC_ADD=SC_ADD_Mod15, .SC_FREQ=0}));   //XTALI=12.288MHz * 3
	VS1003_WriteReg(VS_VOL, 0x0000);         //Maksymalna gono
	SPI_VS_init(F_CPU/7000);                 //Inicjalizacja interfejsu z maksymalnym dla VS taktowaniem
	VS_Buffer_ptr=0;   //Zaczynamy na pocztku bufora
	return true;
}

void VS1003_StartPlay()
{
	UINT br;   //Liczba odczytanych bajtw
	char buf;

	if(VS1003_init())
	{
		do {
			f_lseek(&sound_file, VS_Buffer_ptr);
			f_read(&sound_file, &buf, 1, &br);  //Zapenij bufor danymi
			VS1003_xDCS_Enable(true);
			uint16_t cnt=0;
			while(1)
			{
				VS_1003_DREQ_High();
				SPI_RW_Byte(&VS_USART, sound_file.buf[cnt++]);
				if((cnt == 512) || ((VS_Buffer_ptr + cnt) > f_size(&sound_file))) break;
			}
			VS1003_xDCS_Enable(false);
			VS_Buffer_ptr+=512;
		} while(VS_Buffer_ptr<f_size(&sound_file));

		f_close(&sound_file);    //Zamknij plik
	}
}

void VS1003_SineTest()
{
	VS1003_xCS_Enable(true);
	VS1003_WriteReg(VS_MODE, *(uint16_t*)&((VS_SCI_MODE){.SM_SDINEW=true, .SM_TESTS=true}));
	VS1003_xCS_Enable(false);
	VS_1003_DREQ_High();

	VS1003_xDCS_Enable(true);
	SPI_VS_io_word(0x53ef);
	SPI_VS_io_word(0x6e7e);
	SPI_VS_io_word(0x0000);
	SPI_VS_io_word(0x0000);
	VS1003_xDCS_Enable(false);
}