/**
 * (c)2013 Tomasz Francuz
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 *    Atmel microcontroller product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <avr/interrupt.h>
#include <asf.h>
#include "conf_usb.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "VS1003B.h"
#include "VS_DTMF_Receiver.h"

//Makro umieszczajce zadany acuch w przestrzeni adresowej __flash
#define PGM_STR(X) ((const __flash char[]) { X })

void udi_cdc_write_txt(char *txt);

typedef union
{
	struct
	{
		uint16_t RunningNumer;
		uint16_t TimestampHigh;
		uint16_t TimestampLow;
		uint16_t DTMF_LowGroup;
		uint16_t DTMF_HighGroup;
		uint16_t Reserved0;
		uint16_t Reserved1;
		uint16_t Reserved2;
	};
	uint16_t Words[0];
} VS_DTMF_Message;

const __flash uint8_t DTMF_Codes[4][4]={{'1', '2', '3', 'A'}, {'4', '5', '6', 'B'}, {'7', '8', '9', 'C'}, {'*', '0', '#', 'D'}};

VS_DTMF_Message DTMF_Msg;

char DTMF_GetCode(uint8_t lowgroup, uint8_t highgroup)
{
	if((lowgroup < 4) && (highgroup < 4)) return  DTMF_Codes[lowgroup][highgroup];
	return ' ';   //Poza indeksem
}

int main(void)
{
	VS1003_init();        //Inicjacja ukadu VS1003B
	VS_LoadPlugin();      //Zaaduj plugin dekodera DTMF
	VS1003_WriteReg(VS_AIADDR, 0x0030);  //Uruchom plugin

	PMIC.CTRL = PMIC_LOLVLEN_bm | PMIC_MEDLVLEN_bm | PMIC_HILVLEN_bm; //Wczamy wszystkie poziomy przerwa (potrzebujemy tylko najniszy)
	sei();

	sysclk_init();
	udc_start();

	while (1)
	{
		char Bufor[256];   //Bufor na odebranie linii
		uint8_t ile=0;

		while(1)
		 {
			 ile=VS1003_ReadReg(VS_HDAT1) >> 3;
			 while(ile--)
			 {
				 for (uint8_t j = 0; j < 8; j++) DTMF_Msg.Words[j]=VS1003_ReadReg(VS_HDAT0);
				 sprintf_P(Bufor, PSTR("Msg No %d, Timestamp: %lu, grupa niska: %d, wysoka: %d, kod DTMF: '%c'. \n\r"), DTMF_Msg.RunningNumer,
				           ((uint32_t)DTMF_Msg.TimestampHigh) << 16 | DTMF_Msg.TimestampLow, DTMF_Msg.DTMF_LowGroup, DTMF_Msg.DTMF_HighGroup,
						   DTMF_GetCode(DTMF_Msg.DTMF_LowGroup, DTMF_Msg.DTMF_HighGroup));
				 udi_cdc_write_txt(Bufor);
			 }
		 }
	}
}

void main_suspend_action(void)
{
//Interfejs wchodzi w tryb powerdown
}

void main_resume_action(void)
{
//Wybudzenie interfejsu
}

void main_sof_action(void)
{
//	Odebrano ramk
}

bool main_cdc_enable(uint8_t port)
{
	// Otwarto port CDC
	return true;
}

void main_cdc_disable(uint8_t port)
{
	// Zamknito port CDC
}

void main_cdc_set_dtr(uint8_t port, bool b_enable)
{
	if (b_enable) {
		// Host otwar port COM
	}else{
		// Host zamkn port COM
	}
}

void uart_rx_notify(uint8_t port)
{
	//Opcjonalnie powiadomienie o nadejciu znaku
}

void uart_config(uint8_t port, usb_cdc_line_coding_t * cfg)
{
	//Konfiguracja w odpowiedzi na otwarcie CDC
}

void udi_cdc_write_txt(char *txt)
{
	udi_cdc_write_buf(txt, strlen(txt));
}
