#include <avr\io.h>
#include <avr\pgmspace.h>
#include <avr\interrupt.h>
#include <stdlib.h>
#include "encoder.h"

static int8_t enc_delta;
static uint8_t laststate;

static inline void ReadEncoder();

ISR(TIMER0_OVF_vect)
{
	ReadEncoder();
}

void Timer0Init()
{
	TCCR0B=_BV(CS01);	//Preskaler CLKIO/8
	TIMSK|=_BV(TOIE0);	//Odblokuj przerwanie nadmiaru timera 0
}

bool GetEncButton()
{
	if(laststate & _BV(PB6)) return false; else return true;
}

void ReadEncoder()
{
	static int8_t last;
	static uint8_t counters[3];	//Tablica zawierajca liczniki
	int8_t newpos, diff;
	
	uint8_t state=PINB;
	if(((state^laststate) & _BV(PB4)) && (counters[0]==0))
	{
		counters[0]=200;
		laststate&=(~_BV(PB4));
		laststate|=(state & _BV(PB4));
	}

	if(((state^laststate) & _BV(PB5)) && (counters[1]==0))
	{
		counters[1]=200;
		laststate&=(~_BV(PB5));
		laststate|=(state & _BV(PB5));
	}

	if(((state^laststate) & _BV(PB6)) && (counters[2]==0))
	{
		counters[2]=200;
		laststate&=(~_BV(PB6));
		laststate|=(state & _BV(PB6));
	}

	uint8_t przerwa=0;
	for(uint8_t c=0;c<3;c++)		
		if(counters[c])
		{
			counters[c]--;
			przerwa=1;			//Robimy opnienie tylko jeli ktry z licznikw by- !=0
		}

	newpos=0;
	if((PINB & _BV(PB4))==0) newpos=3;
	if((PINB & _BV(PB5))==0) newpos^=1;	// konwersja kodu Graya na binarny
	diff=last-newpos;
	if(diff & 1)
	{				// bit 0 = krok
    	last=newpos;
		enc_delta+=(diff & 2)-1;	//bit 1 - kierunek
	}
}

int8_t Read1StepEncoder()
{
	ReadEncoder();
	int8_t val=enc_delta;
	enc_delta=0;
	return val;		
}
 
int8_t Read2StepEncoder()
{
	ReadEncoder();
	int8_t val=enc_delta;
  	enc_delta=val & 1;
	return val>>1;
}

int8_t Read4StepEncoder()
{
	ReadEncoder();
	int8_t val=enc_delta;
	enc_delta=val & 3;
	return val>>2;
}

void EncoderInit()
{	//Wyjcia A i B enkodera podczone s do PB4 i 5, przycisk do PB6
	PORTB|=_BV(PB4) | _BV(PB5) | _BV(PB6);	//Wcz pull up na pinie PB4, PB5 i PB6

}

