/*
 * SimpleFS.h
 *
 * Created: 2013-05-12 12:31:03
 *  Author: tmf
 */


#ifndef SIMPLEFS_H_
#define SIMPLEFS_H_

#include <stdint.h>
#include <stdbool.h>

static const uint8_t SimpleFS_MAXFileName = 20;  //Maksymalna dugo nazwy pliku (z kocowym znakiem NULL)

typedef struct
{
	__uint24 Length;          //Dugo caego rekordu - 0xffffff(-1) - rekord jest pusty
	uint8_t DataOffset;       //Przesunicie do pierwszego bajtu danych - 0-255
	char Name[0];             //Nazwa pliku - 1-256 bajtw dugoci w formacie ASCIIZ
	uint8_t Data[0];          //Dane
} SimpleFSEntry;

typedef struct
{
	__uint24 Start;           //Pierwszy bajt danych w pamici FS przydzielony rekordowi
	__uint24 Size;            //Dugo pola danych
	__uint24 Pos;             //Aktualna pozycja odczytu/zapisu
} SimpleFSHandle;

typedef enum
{
	SEEK_SET,
    SEEK_CUR
} FS_SeekMode;

void MS_Format();                                                               //Zainicjuj system plikw
bool MS_AddEntry(const char *name, __uint24 size);                              //Dodaj/utwrz nowy rekord, false jeli nie mona
bool MS_Open(const char *name, SimpleFSHandle *Handle);                         //Zwraca true i wypeniony uchwyt wskazanego rekordu lub false jeli rekord nie znaleziony
__uint24 MS_WriteData(SimpleFSHandle *Handle, void *Data, __uint24 size);       //Zapisz w pamici wskazan liczb bajtw, zapis poza zarezerwowanym przez MS_ddEntry blokiem koczy si bdem, zwraca liczb rzeczywicie zapisanych bajtw
__uint24 MS_ReadData(SimpleFSHandle *Handle, void *Bufor, __uint24 size);       //Odczytaj z pamici i zapisz w buforze wskazan liczb bajtw, zwraca liczb rzeczywicie odczytanych bajtw
void MS_Seek(SimpleFSHandle *Handle, __int24 position, FS_SeekMode mode);       //Ustaw pozycj odczytu/zapisu w pliku
bool MS_GetDirPos(__uint24 *addr, __uint24 *size, char *name, uint8_t bufsize); //Pobiera pozycj pliku z systemu plikw. Nazw umieszcza w name, a jego dugo z size.
                                                                                //bufsize okrela liczb dostpnych pozycji w buforze na nazw. Zwraca false jeli nie ma pozycji
#endif /* SIMPLEFS_H_ */