/*
 * AT45IO.h
 *
 * Created: 2013-04-25 20:17:03
 *  Author: tmf
 */ 


#ifndef AT45IO_H_
#define AT45IO_H_

#include <stdbool.h>
#include <stdint.h>

#define DataFLASH_CS     PIN4_bm    //SygnaCS
#define ADDRANDSIZE(x) &x,sizeof(x)

static const _Bool DataFLASH_Granularity = false;  //false - strony nie s wielkoci potg liczby 2
static const uint16_t DataFLASH_PageSize = 1056;   //Dugo strony pamici

typedef union
{
	struct
	{
		uint8_t PAGE_SIZE : 1;    //Ziarnisto strony
		uint8_t PROTECT   : 1;    //Ochrona wczona?
		uint8_t ID        : 4;    //ID pamici
		uint8_t COMP      : 1;    //Bit porwnania
		uint8_t BUSY      : 1;    //Pami zajta?
	};
	uint8_t byte;
} DataFLASH_Status;

typedef union
{
	struct
	{
		uint8_t ManufacturerID;     //ID producenta
		uint8_t DensityCode    : 5; //Kod wielkoci pamici
		uint8_t FamilyCode     : 3; //Kod rodziny - 001 - FLASH
		uint8_t VersionCode    : 5; //Kod wersji
		uint8_t SLCCode        : 3; //Kod SLC
		uint8_t ExLength;           //Liczba bajtw dodatkowego opisu
	};
	uint8_t byte[0];
} DataFLASH_ID;

typedef enum {CS_Low=0, CS_High=1} DataFLASHCS;

//Wysya polecenie (cmd), odczytuje jego wynika i umieszcza w result. result_size zawiera liczb bajtw do odczytu
void DataFLASH_SendCmd(uint8_t cmd, void *result, uint8_t result_size);

//Wysya polecenie (cmd), po ktrym wysya adres strony lub offsetu w ramach strony (address), nastpnie wysya addbytes bajtw
//zgodnie w wymaganiami danego polecenia. Po wykonaniu stan lini SS pamici zaley od wartoci cs.
void DataFLASH_SendCmdAddr(uint8_t cmd, uint8_t addbytes, __uint24 addr, DataFLASHCS cs);

//Odczytuje size bajtw spod adresu addr i umieszcza je w bufor
void DataFLASH_ReadSeq(__uint24 addr, void *bufor, __uint24 size);

//Czeka na gotowo pamici
void DataFLASH_WaitForBusy();

//Aktywuje/deaktywuje lini SS pamici
void DataFLASH_CSEnable(_Bool cs);

#endif /* AT45IO_H_ */