/*
  Example application to be loaded after VS1003 bootup.
  Activation by
 */


#include <string.h>

#define STANDALONE

#include "vs1003.h"
//#include <h1003/asmfuncs.h>

#include <stdio.h>
#include <stdlib.h>

extern __y s_int16 cos64NewTab[128];

struct SINCTRL {
    u_int16 freq; /*sin frequency*/
    u_int16 svol; /*sin volume*/
    u_int16 ovol; /*mix volume*/
    u_int32 accu;
};

/**
  AddSine uses the SINCTRL structure to generate one sine on top of
  the original signal. There are linear volume controls for both the
  sine and the original signal: 0xffff is full volume, 0x8000 is half,
  0x4000 is 1/4 etc. The freq fiels is a control value that depends on
  the current samplerate.
 */
#if 1
/* Use the assembly version */
auto void AddSine(register __i1 s_int16 *lr, /* points to left or right! */
		  register __b0 s_int16 n,
		  register __i3 struct SINCTRL *sine);
#else
#define PH_SCALE 0 /* more resolution -- the same define in addsine.s */
auto void AddSine(register __i1 s_int16 *lr, /* points to left or right! */
		  register __b0 s_int16 n,
		  register __i3 struct SINCTRL *sine) {
    register __i2 s_int16 i;
    register u_int32 ph = sine->accu;
    register u_int32 add = (u_int32)sine->freq << (7-PH_SCALE);
    for (i=0; i<n; i++) {
	register __i0 __y s_int16 *p = &cos64NewTab[((u_int16)(ph>>16))&127];
	register s_int16 v;

	v = ((s_int32)p[0] * ((u_int16)ph^0xffffU) +
	     (s_int32)p[1/*should be modulo!*/] * (u_int16)ph) >> 16;
	lr[0] = ((s_int32)lr[0] * sine->ovol + (s_int32)v * sine->svol) >> 16;
	lr += 2;   /* next sample from the same channel */
	ph += add; /* update phase */
    }
    sine->accu = ph;
}
#endif


struct SINCTRL sines[4];
u_int16 aictrl0, aictrl1, rate;

//#define GEN_DTMF  /* two sines for both left and right */

s_int16 ApplAddr(register __i0 s_int16 **d, register __a1 s_int16 mode,
		 register __a0 s_int16 n) {
    if (mode == APPL_RESET) {
	aictrl0 = 0;
	aictrl1 = 0;
	rate = 0;
	memset(sines, 0, sizeof(sines));
    }
    if (mode == APPL_AUDIO) {
	/* better frequency resolution, 0.042Hz @ 44100Hz */

#if 1
	/* Here AICTRL0 and AICTRL1 give the frequency and the adder
	   value to the oscillator will be automatically calculated
	   when the samplerate changes. */
	if ((rate & ~1) != (USEX(SCI_AUDATA) & ~1)
	    || aictrl0 != USEX(SCI_AICTRL0)
	    || aictrl1 != USEX(SCI_AICTRL1)) {
	    /* If anything changed, calculate new values */
	    rate = USEX(SCI_AUDATA) & ~1;
	    aictrl0 = USEX(SCI_AICTRL0);
	    aictrl1 = USEX(SCI_AICTRL1);
#ifdef GEN_DTMF
	    sines[2].freq =
#endif
		sines[0].freq = ((u_int32)aictrl0<<16) / rate;
#ifdef GEN_DTMF
	    sines[3].freq =
#endif
		sines[1].freq = ((u_int32)aictrl1<<16) / rate;
	}
#else
	sines[0].freq = USEX(SCI_AICTRL0);
	sines[1].freq = USEX(SCI_AICTRL1);
#endif

#if 0
	/* fade volume smoothly from current to target */
	{
	    register u_int16 new = USEX(SCI_AICTRL2);
	    sines[0].svol += new/16 - sines[0].svol/16;
	    sines[1].svol += new/16 - sines[1].svol/16;
	}
	{
	    register u_int16 new = USEX(SCI_AICTRL3);
	    sines[0].ovol += new/16 - sines[0].ovol/16;
	    sines[1].ovol += new/16 - sines[1].ovol/16;
	}
#else
#ifdef GEN_DTMF /*DTMF sines, the same for both channels*/
	sines[3].svol = sines[2].svol =
	    sines[1].svol = sines[0].svol = USEX(SCI_AICTRL2); /*sine vol*/
	sines[0].ovol = sines[2].ovol = USEX(SCI_AICTRL3); /*original vol*/
	sines[1].ovol = sines[3].ovol = 0xffff;
#else
	sines[0].svol = sines[1].svol = USEX(SCI_AICTRL2); /*sine vol*/
	sines[0].ovol = sines[1].ovol = USEX(SCI_AICTRL3); /*original vol*/
#endif
#endif

#ifdef GEN_DTMF /*DTMF sines, the same for both channels*/
	AddSine(*d,   n, &sines[0]); /* process left channel */
	AddSine(*d,   n, &sines[1]); /* process left channel */
	AddSine(*d+1, n, &sines[2]); /* process right channel */
	AddSine(*d+1, n, &sines[3]); /* process right channel */
#else /*separate left and right sine */
	AddSine(*d,   n, &sines[0]); /* process left channel */
	AddSine(*d+1, n, &sines[1]); /* process right channel */
#endif

    }
    return n;
}
