﻿/*
 * timer_delay.c
 *
 * Created: 2012-07-02 23:46:28
 *  Author: tmf
 */ 


#include <avr/io.h>

void Wait_for(uint16_t delay)       //Realizuje opóźnienie o zadanym czasie liczonym w 
{                                   //odcinkach co 100 us
	TCC0_CTRLA=TC_CLKSEL_OFF_gc;    //Wyłącz timer
	TCC0_CNT=0;
	TCC0_PER=(delay*(F_CPU/10000UL))/256; //Przelicz opóźnienie
	TCC0_INTFLAGS=TC0_OVFIF_bm;     //Skasuj flagę nadmiaru
	TCC0_CTRLA=TC_CLKSEL_DIV256_gc; //Włącz timer z preskalerem 256 razy
	while(!(TCC0_INTFLAGS & TC0_OVFIF_bm)); //Czekaj
}

int main(void)
{
	PORTE_DIR=0xFF;  //Port sterujący LEDami
	
    while(1)
    {
        PORTE_OUTTGL=0xFF;  //Zmień stan wyjść na przeciwne
		Wait_for(10000);    //Odczekaj sekundę
    }
}