/*
 * ColorTextSCART.c
 *
 * Created: 2012-05-02 16:29:02
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdbool.h>
#include <util/delay.h>

#include "Font8x8.h"                             //Tablica czcionek 8x8

#define VIDEO_Scan_line       64                 //Czas trwania caej linii
#define VIDEO_Sync_Len       4.7                 //Czas synchronizacji
#define VIDEO_Back_porch     1.5                 //Czas od koca synchronizacji do wywietlania pikseli
#define VIDEO_Front_porch   1.65                 //Czas od koca wywietlania pikseli do impulsu synchronizacji

#define VIDEO_HLINES        320                  //Liczba linii poziomych (wszystkich) - linie tworzce V-Sync s liczone podwjnie (w sumie 312 linii - 288 obrazu i 8 V-Sync)
#define VIDEO_VSYNC           2                  //Czas trwania VSYNC - 2 linie

#define VIDEO_ACTIVE_PIXEL_START   2             //Pocztek widocznego obszaru linii
#define VIDEO_ACTIVELINE_START    60             //Pierwsza wywietlana linia
#define VIDEO_ACTIVELINE_END     260             //Ostatnia wywietlana linia

#define VIDEO_TXTCOLUMNS     40                  //Dugo linii tekstu (w znakach)
#define VIDEO_TXTLINES       ((VIDEO_ACTIVELINE_END - VIDEO_ACTIVELINE_START)/8)                  //Liczba linii tekstu, liczba linii wywietlanych przez wysoko znaku
#define VIDEO_COLUMNS   (VIDEO_TXTCOLUMNS*8)     //Liczba pikseli

#define US_2_CNT( TIME_US ) (((F_CPU / 1000000L) * (TIME_US) ) - 1)               //Przelicz mikrosekundy na tyknicia timera

uint8_t framebuf[VIDEO_TXTLINES*VIDEO_TXTCOLUMNS*2]; //Bufor ekranu (znaki i ich atrybuty)

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	_delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	return OSC_wait_for_rdy(OSC_RC32MEN_bm); //Zaczekaj na jego poprawny start
}

bool EXCLK_en()
{
	OSC_CTRL |= OSC_XOSCEN_bm;
	return OSC_wait_for_rdy(OSC_XOSCEN_bm);
}

void SelectPLL(OSC_PLLSRC_t src, uint8_t mult)
{
	mult&=OSC_PLLFAC_gm;
	OSC.PLLCTRL=src | mult;              //Ustaw rdo i mnonik PLL
	OSC.CTRL|=OSC_PLLEN_bm;				 //Wcz ukad PLL
	OSC_wait_for_rdy(OSC_PLLRDY_bm);     //Poczekaj na ustabilizowanie si PLL
}

	static uint16_t HLine;               //Licznik linii i plinii
	static uint16_t addr;                //Warto addr musi by przechowywana pomidzy kolejnymi wywoaniami przerwania

ISR(TCC0_CCB_vect)
{
	
	HLine++;
	
    if(HLine <= 16)
	{
		if((HLine>5) && (HLine<=10)) TCC0_CCABUF=US_2_CNT(VIDEO_Scan_line/2) - US_2_CNT(VIDEO_Sync_Len);  //5 szerokich impulsw synchronizacji
		 else TCC0_CCABUF=US_2_CNT(VIDEO_Sync_Len/2);  //5 krtkich impulsw synchronizacji
		 
		 if(HLine == 16)
		 {
			 TCC0_PERBUF=US_2_CNT(VIDEO_Scan_line);     //Czas trwania linii w taktach timera
	         TCC0_CCABUF=US_2_CNT(VIDEO_Sync_Len);      //Czas trwania impulsu synchronizacji dla powrotu poziomego
		 }
		return; //Koniec nadawania synchronizacji
	}

	if((HLine>=VIDEO_ACTIVELINE_START) && (HLine<VIDEO_ACTIVELINE_END))
	{
		asm volatile (                               //Poniszy kod likwiduje jitter zwizany z wejciem do funkcji obsugi przerwania (0-4 cykli)
                       "lds r16, %A0"   "\n\t"
	                   "sbrs r16, 1"    "\n\t"
	                   "lpm"            "\n\t"
	                   "sbrs r16, 0"    "\n\t"
	                   "rjmp .+0"       "\n\t"
					   "sbrc r16, 2"    "\n\t"
					   "rjmp L1%="      "\n\t"
	                   "lpm"            "\n\t"
					   "nop"            "\n\t"
					   "nop"            "\n\t"
					   "L1%=:"            "\n\t"
                       :: "m" (TCC0_CNT) : "r16");
			
		uint8_t chline=(HLine-VIDEO_ACTIVELINE_START) & 0b00000111;    //Numer linii znaku
		TCC1_CTRLA=TC_CLKSEL_OFF_gc; //Wycz zegar
        TCC1_CNT=0;  //Wyrwnanie licznika
		
        asm volatile (
		              "lds r26, addr"            "\n\t"
                      "lds r27, addr+1"          "\n\t"
                      
					  "cpse %[chline], __zero_reg__" "\n\t" //chline==0?
					  "rjmp _l1"                 "\n\t"
					  "adiw r26, 40"             "\n\t" //Dodaj jeden rzd
					  "rjmp _l1a"                "\n\t"
"_l1:"                                           "\n\t"
                      "nop"                      "\n\t" //Wyrwnaj liczb taktw
                      "nop"                      "\n\t"
                      "nop"                      "\n\t"
"_l1a:"                                          "\n\t"
		              "sts addr, r26"            "\n\t" //Zapisz now warto zmiennej addr
                      "sts addr+1, r27"          "\n\t"
					  
					  "ldi r16, lo8(%[framebuf])""\n\t" //X - wskanik do bufora ramki
                      "add r26, r16"             "\n\t"
                      "ldi r16, hi8(%[framebuf])""\n\t"
                      "adc r27, r16"             "\n\t" //X=X+addr
					  
					  "ldi r30, 95"              "\n\t" //95 - liczba znak w generatorze
					  "mul r30, %[chline]"       "\n\t" //Numer wywietlanej linii znaku * liczba znakw w tablicy
					  "ldi r30, lo8(%[font])"    "\n\t" 
					  "ldi r31, hi8(%[font])"    "\n\t"
					  "add r30, r0"              "\n\t"
					  "adc r31, r1"              "\n\t" //Z=Z+chline*95
					  "movw r14, r30"            "\n\t" //r15:14 wskazuje na lini opisu znakw
					  "clr __zero_reg__"         "\n\t" //Wyzeruj rejestr r1
					  
					  "ldi r25, 40"              "\n\t" //Liczba wywietlanych znakw
					  
					  "ld r16, x+"               "\n\t" //Kod znaku
					  "ld r19, x+"               "\n\t" //Atrybuty znaku
					  "movw r30, r14"            "\n\t" //Z - wskanik do tablicy fontw
					  "add r30, r16"             "\n\t"
					  "adc r31, __zero_reg__"    "\n\t" //Dodaj do X kod znaku uzyskujc adres
					  "ld r3,z"                  "\n\t" //Odczytaj bajt opisu znaku

					  "mov r18, r19"             "\n\t" //Powiel atrybut znaku
					  "swap r19"                 "\n\t"             
					  "ldi r16, 1"               "\n\t" //Wybierz preskaler timera C1
					  "sts %[timer], r16"        "\n\t" //na TC_CLKSEL_DIV1_gc
"_l2:"                                           "\n\t"		
//bit 0					  
                      "movw r16, r18"            "\n\t" //Skopiuj atrybuty znaku
					  "mov __tmp_reg__, r3"      "\n\t" //Skopiuj opis znaku
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,7"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
//bit 1
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,6"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "ld r18, x+"               "\n\t" //odczytaj kod kolejnego znaku do wywietlenia
//bit 2
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,5"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "ld r19, x+"               "\n\t" //odczytaj atrybuty kolejnego znaku do wywietlenia
//bit 3
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,4"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "movw r30, r14"            "\n\t" //Z - wskanik do tablicy font8x8
					  "add r30, r18"             "\n\t" //Z=Z + kod znaku				  
//bit 4
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,3"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "mov r18, r19"             "\n\t" //Powiel atrybut znaku
					  "adc r31, __zero_reg__"    "\n\t" 
//bit 5
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,2"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "ld r3,z"                  "\n\t" //Zaaduj bajt opisu znaku (bitmap)
//bit 6
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,1"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "swap r19"                 "\n\t" //Przygotuj atrybut
					  "dec r25"                  "\n\t" //Kolejny znak
//bit 7
					  "out %[portio], r16"       "\n\t" //Zapisz piksel biorc kolor ta lub znaku
					  "sbrs __tmp_reg__,0"       "\n\t" 
					  "out %[portio], r17"       "\n\t" 
					  "brne _l2"                 "\n\t" //brne - 2 takty, odpowiednik dwch instrukcji

                      "nop"	                     "\n\t" //Wyrwnanie do 5 taktw
					  "out %[portio], __zero_reg__"  "\n\t"  //Port IO jest wyzerowany na kocu linii - wymagane ze wzgldu na synchronizacj

		              :: [portio] "I" (_SFR_IO_ADDR(VPORT0_OUT)), [timer] "i" (&TCC1_CTRLA), [chline] "r" (chline), [font] "i" (font8x8), [framebuf] "i" (&framebuf) : "r14", "r15", "r16", "r17", "r18", "r19", "r25", "r26", "r27", "r30", "r31");				  
	} 
	 else if(HLine == 320)
	{
		HLine=0;  //Zaczynamy rysowanie od nowa
		TCC0_PERBUF=US_2_CNT(VIDEO_Scan_line/2);     //Czas trwania linii w taktach timera
	    TCC0.CCABUF=US_2_CNT(VIDEO_Sync_Len/2);      //Czas trwania impulsu synchronizacji dla powrotu pionowego
		addr=-VIDEO_TXTCOLUMNS; //W linii numer 0 zostanie dodane VIDEO_TXTCOLUMNS, w efekcie addr bdzie mia warto 0
	}
}

void DotClockTimer_init()      //Timer okrelajcy czas trwania pikseli
{
	PORTC.DIRSET=1;                          //PC0 - wyjcie z inwersj,
	PORTC.PIN0CTRL=PORT_INVEN_bm;            //co zapewnia odpowiedni ksztat impulsu synchronizacji
	TCC0.PER=US_2_CNT(VIDEO_Scan_line/2);    //Czas trwania poowy linii w taktach timera
	TCC0.CCA=US_2_CNT(VIDEO_Sync_Len/2);     //Czas trwania impulsu synchronizacji dla powrotu pionowego
	TCC0.CCB=((VIDEO_Sync_Len + VIDEO_Back_porch + VIDEO_ACTIVE_PIXEL_START)*F_CPU)/1000000UL; //Czas do rozpoczcia wywietlania pikseli - aktywacji DMA
	TCC0.CTRLB=TC0_CCAEN_bm | TC_WGMODE_SS_gc;     //Single slope mode
	TCC0.INTCTRLB=TC_CCBINTLVL_HI_gc;        //Odblokuj przerwania pocztku aktywnego obszaru linii
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;            //Timer taktowany z CLKPER
}

void SynchTimer_init()
{
	TCC1.PER=4;  //Czas wysania jednego pixela - 5 taktw CPU
    TCC1.CCA=1; //Sygna strobu zatrzasku generujemy na pocztku - trwa 1 takt CPU
	TCC1.CTRLB=TC1_CCAEN_bm | TC_WGMODE_SS_gc;  //Aktywuj sygna strobu na PC4, tryb single slope
	PORTC_DIRSET=0b00010000;      //PC4 jest wyjciem
}

void IO_init()
{
	PORTCFG_VPCTRLA=PORTCFG_VP0MAP_PORTA_gc;     //Mapuj PORTA jako wirtualny port 0
	VPORT0_DIR=0b00000111;    //Wyjcia koloru RGB
}

void INT_init()
{
	PMIC_CTRL|=PMIC_HILVLEN_bm;     //Odblokuj przerwania niskiego poziomu
	sei();
}

int main(void)
{
	//RC32M_en();                       //Odblokuj wewntrzny generator RC
	
	EXCLK_en();                         //Odblokuj zegar zewntrzny doprowadzony do XTAL1
    SelectPLL(OSC_PLLSRC_XOSC_gc, 8);   //FXTAL1=4 MHz * 8 = 32 MHz


	CPU_CCP=CCP_IOREG_gc;            //Odblokuj zmian konfiguracji
	//CLK.CTRL=CLK_SCLKSEL_RC32M_gc;   //Wybierz generator RC 32MHz
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;     //Wybierz PLL
	
	uint8_t a=0x0F;
	
	for(uint8_t y=0; y<VIDEO_TXTLINES; y++)
	  for(uint8_t x=0; x<VIDEO_TXTCOLUMNS*2; x+=2)
	   {
        framebuf[y*VIDEO_TXTCOLUMNS+x]=(x+y) % 96;  //Zapisz kod znaku
		framebuf[y*VIDEO_TXTCOLUMNS+x+1]=a;      //Zapisz jego atrybuty
		a^=0xFF;
	   }		
	
	DotClockTimer_init();            //Zainicjuj timer zliczajcy piksele
	SynchTimer_init();
	IO_init();                       //Zainicjuj piny RGB
	INT_init();                      //Wcz przerwania
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}
