/*
* mp3.c
*
* Created: 2013-10-07 20:50:35
*  Author: tmf
*/


#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <stdlib.h>
#include <string.h>
#include "VS1003B.h"
#include "VS1003Bconfig.h"
#include "st7565/ST7565.h"
#include "KBD.h"
#include "SD.h"
#include "ff.h"
#include "menu.h"

//Uchwyty do tablic czcionek
extern const __flash uint8_t* const __flash system16_array[];
extern const __flash uint8_t* const __flash system12_array[];
extern const __flash uint8_t* const __flash system8_array[];

//Czcionka uywana do wywietlenia menu
const __flash uint8_t* const __flash *Menu_font = system8_array;

//Struktura wywietlanego menu
struct _menuitem *menu;

FATFS fatfs;                           //System plikw na karcie

void Player_NoCard()
{
	st7565r_Clear(false);        //Wyczy ekran
	st7565r_SetText(0, 8, PSTR("No card!"), system16_array, false);
	st7565r_CpyDirtyPages();    //Aktualizacja ekranu
	while(SD_CardInit() == false);
	st7565r_Clear(false);        //Wyczy ekran
	st7565r_CpyDirtyPages();    //Aktualizacja ekranu
}

void Menu_ReScan();

void Menu_Free(struct _menuitem *ptr)
{
	struct _menuitem *tmp;
	while(ptr)
	{
		tmp=ptr;
		free(tmp->text);   //Zwalniamy miejsce przydzielone nazwie menu
		free(tmp->ptr);    //Zwalniamy FILINFO
		ptr=tmp->next;
		free (tmp);        //Zwalniamy struktur _menuitem
	}
}

void Menu_Click_Func(struct _menuitem *ptritem)
{
	  if(((FILINFO*)(ptritem->ptr))->fattrib & AM_DIR)    //Jeli pozycja jest katalogiem to otwieramy go
	  {
		  FRESULT res=f_chdir(((FILINFO*)(ptritem->ptr))->fname);  //Uywamy tylko nazwy kanonicznej
		  if(res == FR_OK)
		  {
			  Menu_Free(menu);         //Zwolnij dane
			  Menu_ReScan();           //Odczytaj nowy katalog
			  Menu_init();             //Utwrz menu, wracajc z funkcji rozstanie ono automatycznie wywietlone
		  }
	  } else
	  {
		  if(f_open(&sound_file, ((FILINFO*)(ptritem->ptr))->fname, FA_READ) == FR_OK)  //Otwrz plik zawierajcy dwik
		  {
			  VS1003_StartPlay();      //Rozpocznij odtwarzanie dwiku
		  }
	  }
}

void Menu_AddItem(char *bufor, FILINFO *finfo)
{
	struct _menuitem *tmp=malloc(sizeof(struct _menuitem));  //Zaalokuj miejsce na menu
	tmp->text=strdup(bufor);                                 //Skopiuj nazw
	tmp->parent=NULL;
	tmp->menuitemfunc=Menu_Click_Func;  //Funkcja odpowiedzialna za obsug wybranej pozycji menu
	tmp->submenu=NULL;
	tmp->next=NULL;
	tmp->ptr=malloc(sizeof(FILINFO)); //Przydziel pami na dane o pliku
	memcpy(tmp->ptr, finfo, sizeof(FILINFO)); //Skopiuj dane. UWAGA! Robimy tylko kopiowanie pytkie

	if(menu) tmp->next=menu;
	menu=tmp;
}

void Menu_Run()
{
	 uint8_t OldButtons=0;  //Poprzedni stan klawiszy

	 while(1)
	 {
	  	uint8_t tmpbtn=Buttons;
	  	if(((tmpbtn ^ OldButtons) & 1) && (tmpbtn & 1)) Menu_Click();       //Wcinity SW1
	  	if(((tmpbtn ^ OldButtons) & 2) && (tmpbtn & 2)) Menu_SelectPrev();  //Wcinity SW1
	  	if(((tmpbtn ^ OldButtons) & 4) && (tmpbtn & 4)) Menu_SelectNext();  //Wcinity SW2
	  	OldButtons=tmpbtn;
	 }
}

void Menu_ReScan()
 {
	menu=NULL;
	FRESULT res;
	FILINFO fno;
	DIR dir;
	char *fn;
	#if _USE_LFN                    //Tylko jeli uywamy dugich nazw plikw
	static char lfn[_MAX_LFN + 1];
	fno.lfname = lfn;
	fno.lfsize = sizeof lfn;
	#endif
	char Bufor[_MAX_LFN + 1];
	f_getcwd(Bufor, sizeof(Bufor));

	res = f_opendir(&dir, Bufor);                       // Otwrz katalog
	if (res == FR_OK)
	{
		for (;;)
		{
			res = f_readdir(&dir, &fno);                   //Odczytaj pozycj z katalogu
			if (res != FR_OK || fno.fname[0] == 0) break;  //Jeli wystpi bd lub nie ma wicej pozycji to zakocz
			if((fno.fname[0] == '.') && (fno.fname[1] != '.')) continue;     //Jedn z pozycji jest '.' - zignoruj
			#if _USE_LFN
			fn = *fno.lfname ? fno.lfname : fno.fname;
			#else
			fn = fno.fname;
			#endif
			if (fno.fattrib & AM_DIR)
			sprintf(Bufor, "%-12s <DIR>", fn);   //Odczytana pozycja jest katalogiem
			else sprintf(Bufor, "%-12s ", fn);   //Odczytana pozycja jest plikiem
			Menu_AddItem(Bufor, &fno);
		}
	}
}

void Player_ReadCurrDir()
{
	Menu_ReScan();   //Odczytaj katalog
	Menu_init();
	Menu_Show();

	Menu_Run();
}

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	_delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

void SelectPLL(OSC_PLLSRC_t src, uint8_t mult)
{
	mult&=OSC_PLLFAC_gm;
	OSC.PLLCTRL=src | mult;              //Ustaw rdo i mnonik PLL
	OSC.CTRL|=OSC_PLLEN_bm;				 //Wcz ukad PLL
	OSC_wait_for_rdy(OSC_PLLRDY_bm);     //Poczekaj na ustabilizowanie si PLL
}

int main(void)
{
	SelectPLL(OSC_PLLSRC_RC2M_gc, 15);  //Zwikszamy taktowanie - potrzebujemy >4 MHz
	CPU_CCP=CCP_IOREG_gc;               //Odblokuj zmian konfiguracji
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;        //Wybierz PLL

	VS1003_init();           //Inicjalizacja VS1003B i portu z nim zwizanego
	st7565r_SPI_init();      //Inicjalizacja portu SPI (USARTD0) zwizanego z LCD
	st7565r_init();          //i samego LCD
	LCD_BackLight_Init();    //oraz jego podwietlenia
	st7565r_Clear(false);    //Wyczy LCD
	st7565r_CpyDirtyPages(); //Uaktualnij LCD
	Kbd_init();              //Zainicjuj obsuge klawiszy
	SD_SPI_init();           //Zainicjuj interfejs SPI uywany przez kart SD

	PMIC_CTRL=PMIC_LOLVLEN_bm | PMIC_MEDLVLEN_bm; //Odblokuj wybrane przerwania
	sei();

	Player_NoCard();         //Zainicjuj kart SD, a jeli jej nie ma wywietl finformacj
	f_mount(0, &fatfs);      //Dostp do systemu plikw

	Player_ReadCurrDir();    //Odczytaj biecy katalog

	while(1)
	{

		_delay_ms(100);
	}
}