/*
 * DAC2CH.c
 *
 * Created: 2012-03-24 11:47:33
 *  Author: tmf
 */ 


#include <avr/io.h>

uint16_t wave_triangle[] ={0,4096>>4, 8192>>4, 12288>>4, 16384>>4, 20480>>4, 24576>>4, 28672>>4, 32768>>4, 36863>>4, 40959>>4, 45055>>4, 49151>>4, 53247>>4, 57343>>4,      //32 prbki
	61439>>4, 57343>>4, 53247>>4, 49151>>4, 45055>>4, 40959>>4, 36863>>4, 32768>>4, 28672>>4, 24576>>4, 20480>>4, 16384>>4, 12288>>4, 8192>>4, 4096>>4};
	
uint16_t wave_sin[] ={32768>>4, 38458>>4, 43975>>4, 49151>>4, 53830>>4, 57869>>4, 61145>>4, 63559>>4, 65037>>4, 65535>>4, 65037>>4, 63559>>4, 61145>>4, 57869>>4, 53830>>4, 49151>>4, 43975>>4, 38458>>4,
	                32768>>4, 27077>>4, 21560>>4, 16384>>4, 11705>>4, 7666>>4, 4390>>4, 1976>>4, 498>>4, 0>>4, 498>>4, 1976>>4, 4390>>4, 7666>>4, 11705>>4, 16384>>4, 21560>>4, 27077>>4};

void DAC_init()
{
	DACA.CTRLC=DAC_REFSEL_INT1V_gc;                //Wewn. napicie ref. 1 V
	DACA.TIMCTRL=DAC_CONINTVAL_32CLK_gc | DAC_REFRESH_128CLK_gc;           //CLK/32
	DACA.CTRLB=DAC_CH0TRIG_bm | DAC_CH1TRIG_bm | DAC_CHSEL_DUAL_gc; //Konwersja wyzwalana zdarzeniem, dwukanaowa
	DACA.EVCTRL=DAC_EVSEL_0_gc;              //EvCh 0
	EVSYS_CH0MUX=EVSYS_CHMUX_PRESCALER_1_gc; //taktowanie evch0 z CLKPer
	DACA.CTRLA=DAC_ENABLE_bm | DAC_CH0EN_bm | DAC_CH1EN_bm; //Wcz DAC, kana 0 i 1 routowany na IO (PA2 i PA3)
}

void DMA_init()
{
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez double buffering
	
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok, adres docelowy co paczk
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_DACA_CH0_gc; //Zdarzeniem wyzwalajcym jest pusty rejestr danych kanau CH0 DACA
	DMA.CH0.TRFCNT=sizeof(wave_triangle);                //Blok ma dugo tablicy prbek
	DMA.CH0.REPCNT=0;                           //Transfer bdzie pwtarzany w nieskoczono
	DMA.CH0.SRCADDR0=(uint16_t)&wave_triangle & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&wave_triangle >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica wave
	DMA.CH0.DESTADDR0=(uint16_t)(&DACA.CH0DATA) & 0xFF; //Dane wpisujemy do rejestru DATA ukadu DAC
	DMA.CH0.DESTADDR1=(uint16_t)(&DACA.CH0DATA) >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_2BYTE_gc | DMA_CH_SINGLE_bm;  //Kana 0 w trybie powtarzania, dugo transferu 2 bajty, single shot	
	
	DMA.CH1.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok, adres docelowy co paczk
	DMA.CH1.TRIGSRC=DMA_CH_TRIGSRC_DACA_CH0_gc; //Zdarzeniem wyzwalajcym jest pusty rejestr danych DACA
	DMA.CH1.TRFCNT=sizeof(wave_sin);                //Blok ma dugo tablicy prbek
	DMA.CH1.REPCNT=0;                           //Transfer bdzie pwtarzany w nieskoczono
	DMA.CH1.SRCADDR0=(uint16_t)&wave_sin & 0xFF;
	DMA.CH1.SRCADDR1=(uint16_t)&wave_sin >>8;
	DMA.CH1.SRCADDR2=0;                        //rdem danych jest tablica wave
	DMA.CH1.DESTADDR0=(uint16_t)(&DACA.CH1DATA) & 0xFF; //Dane wpisujemy do rejestru DATA ukadu DAC
	DMA.CH1.DESTADDR1=(uint16_t)(&DACA.CH1DATA) >> 8;
	DMA.CH1.DESTADDR2=0;
	DMA.CH1.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_2BYTE_gc | DMA_CH_SINGLE_bm;  //Kana 0 w trybie powtarzania, dugo transferu 2 bajty, single shot	
}

int main(void)
{
	DMA_init();
	DAC_init();
}