/*
 * RTC.h
 *
 * Created: 2012-12-26 11:42:21
 *  Author: tmf
 */


#ifndef RTC_H_
#define RTC_H_

#include <avr/io.h>
#include <stdint.h>
#include <calendar.h>

extern struct calendar_date dt;           //Aktualna data i czas

void BatBackup_init();      //Funkcja inicjujca cay podsystem podtrzymania i ukad RTC32
void RTC32_init();          //Funkcja inicjujca timer RTC32
uint8_t BatBackup_status(); //Funkcja zwraca stan uk. podtrzymywania, 0 jeli wszystko ok

static inline uint32_t RTC32_get_counter()     //Pobiera warto licznika RTC32
{
	RTC32.SYNCCTRL = RTC32_SYNCCNT_bm;         //Ustaw flag SYNCCNT
	while (RTC32.SYNCCTRL & RTC32_SYNCCNT_bm); //Poczekaj na jej skasowanie, co sygnalizuje gotowo rejestru CNT
	return RTC32.CNT;                          //Zwr odczytan warto rejestru CNT
}

void RTC32_set_counter(uint32_t cnt);  //Ustaw now warto licznika cnt, zaczekaj na synchronizacj

#endif /* RTC_H_ */