/*
 * ADV.h
 *
 * Created: 2013-01-15 21:05:09
 *  Author: tmf
 */ 

#ifndef ADV_H_
#define ADV_H_

#include <stdint.h>

#define FIELD_FORMAT_SIGNED       1       // data field is signed integer
#define FIELD_FORMAT_UNSIGNED     2       // data field is unsigned integer
#define FIELD_FORMAT_FLOAT        3       // data field is floating point

#define ADV_PKT_CONFIG_START      0x01    // config start packet
#define ADV_PKT_CONFIG_END        0x02    // config start packet
#define ADV_PKT_CONFIG_STREAM     0x03    // stream config packet
#define ADV_PKT_CONFIG_FIELD      0x04    // data field config packet
#define ADV_PKT_DATA              0x05    // data packet

#define ADV_PKT_HEADER            0x5aFF  //Nagwek pakietu ADV

typedef struct
{
	uint16_t Header;                  //Nagwek - 0xff, 0x5a
	uint16_t Packet_length;           //Liczba bajtw zajtych przez struktur
	uint8_t  Packet_type;             //Typ pakietu
} ADV_base;	

typedef struct  
{
	uint8_t  Checksum;                //Suma kontrolna - nieuywane
	uint8_t  End_marker;              //0x06 - znacznik koca pakietu	
} ADV_End;

typedef struct                        //Typ pakietu - 0x01 - Start-of-configuration
{
    ADV_base;
	uint8_t  Number_of_data_streams;  //Liczba strumieni danych
	ADV_End;
} ADV_Start_cfg_t;

typedef struct                        //Typ pakietu - 0x03 - Stream-configuration-packet
{
    ADV_base;
	uint8_t  Stream_number;           //Numer strumienia
	uint32_t Tick_resolution;         //Rozdzielczo pomiaru w Hz
	uint8_t  Data_field;              //Liczba pl danych w pakiecie
	char     Stream_name[25];         //Nazwa strumienia - max 24 znaki + NULL
	ADV_End;
} ADV_Stream_cfg_t;

typedef struct                        //Typ pakietu - 0x04 - Field-configuration
{
    ADV_base;
	uint8_t  Stream_number;           //Numer strumienia
	uint8_t  Field_number;            //Nr pola, poczwszy od 0x01
	uint8_t  Field_length;            //Dugo pola danych w bajtach
	uint8_t  Format;                  //Dane typu unsigned (0x01) lub signed (0x02)
	uint32_t Min_value;               //Minimalna warto - skala osi
	uint32_t Max_value;               //Maksymalna warto - skala osi
	char     Units[20];               //Nazwa jednostki danych (NULLZ)
	char     Name[11];                //Nazwa pola danych (NULLZ)
	ADV_End;
} ADV_Data_cfg_t;

typedef struct                        //Typ pakietu - 0x02 - End-of-configuration
{
    ADV_base;
	uint8_t  Number_of_data_streams;  //Liczba strumieni danych
	ADV_End;
} ADV_End_cfg_t;

typedef struct                        //Typ pakietu - 0x04 - Field-configuration
{
    ADV_base;
	uint8_t  Stream_number;           //Numer strumienia
	uint32_t Timestamp;               //Marker czasowy
	uint32_t Data;
	ADV_End;
} ADV_Data_uint_pkt_t;

typedef struct                        //Typ pakietu - 0x04 - Field-configuration
{
	ADV_base;
	uint8_t  Stream_number;           //Numer strumienia
	uint32_t Timestamp;               //Marker czasowy
	float Data;
	ADV_End;
} ADV_Data_float_pkt_t;

#endif /* ADV_H_ */