/*
 * SDRAM.h
 *
 * Created: 2012-04-20 18:51:25
 *  Author: tmf
 */ 


#ifndef SDRAM_H_
#define SDRAM_H_

#include <avr/io.h>

typedef uint32_t hugemem_ptr_t;

#define HUGEMEM_NULL    0

void SDRAM_init();    //Inicjalizacja zewntrznej pamici SDRAM

static inline uint_fast8_t hugemem_read8(const hugemem_ptr_t from)
{
	uint8_t value;

	asm volatile(
		"movw r30, %A1 \n\t"
		"out %2, %C1 \n\t"
		"ld %0, Z \n\t"
		"out %2, __zero_reg__ \n\t"
		: "=r"(value)
		: "r"(from), "i"(&RAMPZ)
		: "r30", "r31"
	);

	return value;
}

static inline void hugemem_write8(hugemem_ptr_t to, uint_fast8_t val)
{
	asm volatile(
		"movw r30, %A0 \n\t"
		"out %2, %C0 \n\t"
		"st Z, %1 \n\t"
		"out %2, __zero_reg__ \n\t"
		:
		: "r"(to), "r"(val), "i"(&RAMPZ)
		: "r30", "r31"
	);
}



#endif /* SDRAM_H_ */