#ifndef _MENU_H
#define _MENU_H

#include <stdbool.h>
#include <stdint.h>

struct _menuitem;
typedef void (*menuitemfuncptr)(struct _menuitem *ptritem);

struct _menuitem
{
	char * text;
	menuitemfuncptr menuitemfunc;
	void *ptr;                    //Wskanik na dane uytkownika powizane z menu
	struct _menuitem *parent;
	struct _menuitem *submenu;
	struct _menuitem *next;
};

void Menu_init();
void Menu_Show();
void Menu_SelectNext();
void Menu_SelectPrev();
void Menu_Click();
void Menu_Back();

extern struct _menuitem *menu;                              //Struktura menu
extern const __flash uint8_t* const __flash *Menu_font;     //Czcionka uywana przez menu

#endif
