/*
 * VS_Player.c
 *
 * Created: 2013-11-23 20:44:34
 *  Author: tmf
 */

#include "VS_Player.h"
#include <stdio.h>
#include <avr/pgmspace.h>
#include "VS1003B.h"
#include <util/atomic.h>
#include <string.h>
#include <stdlib.h>
#include "KBD.h"

void Menu_Snd_VolumeFunc(struct _menuitem *ptritem);  //Ustaw gono odtwarzania

struct _menuitem playmenu={NULL, NULL, NULL, NULL, NULL,           //Menu wywietlane w czasie odtwarzania utworu
	&(struct _menuitem){"Time 00:00:00", NULL, NULL, NULL, NULL,
		&(struct _menuitem){"Attenuation    0 dB", Menu_Snd_VolumeFunc, NULL, NULL, NULL,
			&(struct _menuitem){"Back", Menu_Back, NULL, NULL, NULL, NULL}}}};


void Menu_AddInfoSubmenu(struct _menuitem *parent)  //Dostosowuje informacj w menu do aktualnie odtwarzanego utworu
{
	playmenu.text=parent->text;             //Ta sama nazwa utworu
	playmenu.next->next->next->parent=menu; //Zmie pole parent pozycji "Back", abymy mogli wrci do menu wyszego poziomu
	parent->submenu=&playmenu;              //Dodaj podmenu do listy
}

void Menu_Snd_VolumeFunc(struct _menuitem *ptritem)
{
	uint8_t OldVolume;
	while(Buttons & 1)  //Dopki jest nacinity SW0
	{
		OldVolume=VS_Volume;
		if(Buttons & 2) if(VS_Volume < 254) VS_Volume++;    //SW1 zwiksza gono
		if(Buttons & 4) if(VS_Volume > 0) VS_Volume--;      //SW2 zmniejsza gono
		if(OldVolume != VS_Volume)    //Czy co si zmienio?
		{
			sprintf_P(playmenu.next->next->text, PSTR("Attenuation %d dB"), VS_Volume);
			Menu_Show();      //Uaktualnij wywietlan informacj
			VS1003_AddCommand(VS_WRITE_CMD, VS_VOL, &(uint16_t){VS_Volume | (VS_Volume << 8)});  //Ustaw nowe tumienie
		}
	}
}

void Menu_PlayStatus()
{
	uint16_t snd_time;

	if(VS_Status > VS_NoPlaying)
	{
		VS1003_AddCommand(VS_READ_CMD, VS_DECODE_TIME, &snd_time);
		sprintf_P(&playmenu.next->text[5], PSTR("%02u:%02u:%02u"), snd_time/3600, (snd_time/60) % 60, snd_time % 60);
	}
}

void Menu_Run()
{
	uint8_t OldButtons=Buttons;  //Poprzedni stan klawiszy
	uint16_t cnt=cnt;            //Dla usatysfakcjonowania kompilatora
	MenuMainLoopExit=false;

	while(MenuMainLoopExit == false)
	{
		uint8_t tmpbtn=Buttons;
		if(((tmpbtn ^ OldButtons) & 1) && (tmpbtn & 1)) Menu_Click();       //Wcinity SW0
		if(((tmpbtn ^ OldButtons) & 2) && (tmpbtn & 2)) Menu_SelectPrev();  //Wcinity SW1
		if(((tmpbtn ^ OldButtons) & 4) && (tmpbtn & 4)) Menu_SelectNext();  //Wcinity SW2
		OldButtons=tmpbtn;
		if((cnt++ % 1000) == 0)
		{
			Menu_PlayStatus();              //Jeli co odtwarzamy to uaktualnij info o czasie, byle niezbyt czsto :)
			Menu_Show();
		}
	}
}

void Menu_Click_Func(struct _menuitem *ptritem)
{
	if(((FILINFO*)(ptritem->ptr))->fattrib & AM_DIR)    //Jeli pozycja jest katalogiem to otwieramy go
	{
		FRESULT res=f_chdir(((FILINFO*)(ptritem->ptr))->fname);  //Uywamy tylko nazwy kanonicznej
		if(res == FR_OK)
		{
			Menu_ReScan();           //Odczytaj nowy katalog
			Menu_init();             //Utwrz menu, wracajc z funkcji rozstanie ono automatycznie wywietlone
		}
	} else
	{
		if((VS_Status == VS_NoPlaying) || (ptritem->submenu == NULL))  //Jeeli nic nie odtwarzamy to skasuj info o poprzednio odtwarzanym utworze
		{
			struct _menuitem *tmpmenu=menu;
			while(tmpmenu)              //Usuwamy odwoania do podmenu - informacji o odtwarzanym pliku
			{
				tmpmenu->submenu=NULL;
				tmpmenu=tmpmenu->next;
			}
		}
		if(ptritem->submenu == NULL)
		{
			if(VS_Status > VS_NoPlaying)  //Aktualnie co odtwarzamy, wic najpierw trzeba to przerwa
			{
				VS_Status=VS_NoPlaying;
				ATOMIC_BLOCK(ATOMIC_FORCEON) { f_close(&sound_file); }
			}
			if(f_open(&sound_file, ((FILINFO*)(ptritem->ptr))->fname, FA_READ) == FR_OK)  //Otwrz plik zawierajcy dwik, jeli jest podmenu to znaczy, e plik by ju otwarty
			{
				Menu_AddInfoSubmenu(ptritem);   //Dodaj submenu z informacjami o odtwarzanym utworze
				VS1003_StartPlay();      //Rozpocznij odtwarzanie dwiku
			}
		}
		Menu_GoSubMenu();
	}
}

void Menu_AddItem(char *bufor, FILINFO *finfo)
{
	struct _menuitem *tmp=malloc(sizeof(struct _menuitem));  //Zaalokuj miejsce na menu
	tmp->text=strdup(bufor);                                 //Skopiuj nazw
	tmp->parent=NULL;
	tmp->menuitemfunc=Menu_Click_Func;  //Funkcja odpowiedzialna za obsug wybranej pozycji menu
	tmp->submenu=NULL;
	tmp->ptr=malloc(sizeof(FILINFO)); //Przydziel pami na dane o pliku
	memcpy(tmp->ptr, finfo, sizeof(FILINFO)); //Skopiuj dane. UWAGA! Robimy tylko kopiowanie pytkie

	tmp->next=menu;
	menu=tmp;
}

void Menu_ReScan()
{
	Menu_Free(menu);         //Zwolnij dane
	menu=NULL;
	FRESULT res;
	FILINFO fno;
	DIR dir;
	char *fn;
	#if _USE_LFN                    //Tylko jeli uywamy dugich nazw plikw
	static char lfn[_MAX_LFN + 1];
	fno.lfname=lfn;
	fno.lfsize=sizeof lfn;
	#endif
	char Bufor[_MAX_LFN + 1];
	ATOMIC_BLOCK(ATOMIC_FORCEON) {f_getcwd(Bufor, sizeof(Bufor));}

	ATOMIC_BLOCK(ATOMIC_FORCEON) {res = f_opendir(&dir, Bufor);}             // Otwrz katalog
	if(res == FR_OK)
	{
		for (;;)
		{
			ATOMIC_BLOCK(ATOMIC_FORCEON) {res = f_readdir(&dir, &fno);}      //Odczytaj pozycj z katalogu
			if(res != FR_OK || fno.fname[0] == 0) break;                     //Jeli wystpi bd lub nie ma wicej pozycji to zakocz
			if((fno.fname[0] == '.') && (fno.fname[1] != '.')) continue;     //Jedn z pozycji jest '.' - zignoruj
			#if _USE_LFN
			fn = *fno.lfname ? fno.lfname : fno.fname;
			#else
			fn = fno.fname;
			#endif
			if (fno.fattrib & AM_DIR)
			sprintf(Bufor, "%-12s <DIR>", fn);   //Odczytana pozycja jest katalogiem
			else sprintf(Bufor, "%-12s ", fn);   //Odczytana pozycja jest plikiem
			Menu_AddItem(Bufor, &fno);
		}
	}
	struct _menuitem *tmp=malloc(sizeof(struct _menuitem));  //Zaalokuj miejsce na menu umoliwiajce powrt do menu gwnego
	tmp->text=strdup("<BACK>");                              //Skopiuj nazw
	tmp->parent=NULL;
	tmp->menuitemfunc=MenuMainLoop_Back;  //Funkcja odpowiedzialna za obsug wybranej pozycji menu
	tmp->submenu=NULL;
	tmp->ptr=NULL; //Przydziel pami na dane o pliku
	tmp->next=menu;
	menu=tmp;
}
