#ifndef IMA_H
#define IMA_H

//#include "vsmpg.h"

#define ISSTMAX 88
#define IMA_ENCODE_BLOCK_ALIGN 256
#define IMA_ENCODE_SAMPLES (2*IMA_ENCODE_BLOCK_ALIGN-7)
#if 1
#define IMA_ENCODE_BSSPACE (IMA_ENCODE_BLOCK_ALIGN*4) // must be power of 2
#endif

#ifndef ASM
extern const s_int16 imaStepSizeTable[ISSTMAX + 1];
#ifdef __VSDSP__
auto s_int16 ImaUpdateState(register __a0 s_int16 val,
			    register __b0 s_int16 step,
			    register __i3 s_int16 *st,
			    register __c0 s_int16 c);
#else
auto s_int16 ImaUpdateState(register __a0 s_int16 val,
			    register __b0 s_int16 step,
			    register __i3 s_int16 *st,
			    register __c0 s_int16 c);
#endif

void ImaExpand(s_int16 n, register __i0 const u_int16 __y *ip,
    register __i1 s_int16 *op);

#ifdef __VSDSP__
auto s_int16 ImaDiv(register __a0 s_int16 a, register __b0 s_int16 b,
		    register __d1 s_int16 step);
#else
auto s_int16 ImaDiv(register __a0 s_int16 a, register __b0 s_int16 b,
		    register __d1 s_int16 step);
#endif

auto u_int16 InitImaEncode(void);


auto void SetImaFill(void);
s_int16 Sat16(register __a s_int32 n); /* NOT auto! */

extern u_int16 __y imaStereoPatch;
void ImaExpandStereo(
    s_int16 n,        /* samples to decode PER channel, REQUIRE n % 8 == 1  */
    register __i3 const __y u_int16 *ip, /* input buffer[blockAlign]   */
    s_int16 *op        /* obuff[2*n] will be output samples */
    );

auto void SetImaGains(void);
#endif	/* !ASM */

#define MOD_BUF_SIZE 64
#define IMA_BUF_SIZE 512

#ifndef ASM
volatile extern s_int16 __y * __y mod_wr_pointer;
volatile extern s_int16 __y * __y mod_rd_pointer;
volatile extern u_int16 __y * __y ima_wr_pointer;
volatile extern u_int16 __y * __y ima_rd_pointer;
extern s_int16 __y modBuf[MOD_BUF_SIZE];
auto s_int16 ModBufFill(void);
auto s_int16 __y *ModBufCopy(register __i0 s_int16 *d,
			     register __a0 s_int16 n);
auto void *ModBufToStereo(register __i0 s_int16 *d, register __a0 s_int16 n);
s_int16 GetModSamples(register __i0 struct Filter *f,
		      register __i1 s_int16 *d, register __a0 s_int16 n);
void ImaEncodeSamples(s_int16 *s, s_int16 n, s_int16 sourceStep);
extern u_int16 __y imaOutBuf[IMA_BUF_SIZE];
#endif

#endif
