#include "menubar.h"
#include "lcd.h"
#include <stddef.h>
#include <string.h>
#include "defines.h"

#define GetAddr(ptr, field) (void*)pgm_read_word(((uint8_t*)ptr)+offsetof(struct _menuitem, field))

static const struct _menuitem *currMenuPtr=&menu;
static int8_t menuindex;
static int8_t menufirstpos;

const struct _menuitem *GetMenuItem(uint8_t index)
{
	const struct _menuitem *tmpmenuitem=currMenuPtr;

	while((tmpmenuitem) && (index>0))
	{
	 tmpmenuitem=GetAddr(tmpmenuitem, next);
	 index--;
	}
	return tmpmenuitem;
}

/*bool Menu_isOnList(struct _menuitem *parent, struct _menuitem *item)
{
	while(parent)
	{
		if(parent==item) return true;
		parent=GetAddr(parent, next);
	}
	return false;
}

bool Menu_isSubmenu(struct _menuitem *mi)
{
	struct _menuitem *parent=GetAddr(mi, parent);
	if(Menu_isOnList(parent, mi)==true)
	 {
		if(GetAddr(parent, parent)) return true;
     } else return true;
	return false;
}*/

void Menu_Show()
{
	const struct _menuitem *tmpmenuitem=GetMenuItem(menufirstpos);
	
	for(uint8_t i=0;i<LCD_ROWS;i++)
	{
		uint8_t charcnt=1;
		lcd_goto(0,i);
		if((i+menufirstpos)==menuindex) lcd_putchar('>'); else lcd_putchar(' ');
		if(GetAddr(tmpmenuitem, text))
		 {
		  lcd_puttext_P(GetAddr(tmpmenuitem, text));
		  charcnt+=strlen_P(GetAddr(tmpmenuitem, text));
		 }
		if(GetAddr(tmpmenuitem, submenu))
		 {
		  lcd_putchar(0x7E);
		  charcnt++;
         }
        for(;charcnt<LCD_COLUMNS;charcnt++) lcd_putchar(' '); //Wyczy reszt wywietlanej linii
		tmpmenuitem=GetAddr(tmpmenuitem, next);
	}
}

void Menu_SelectNext()
{
	if(GetMenuItem(menuindex+1)!=0)
	 {
	  menuindex++;
	  if((menuindex-menufirstpos)>=LCD_ROWS) menufirstpos++;
	 } else
	 {
	  menuindex=0;
	  menufirstpos=0;
     }
	Menu_Show();
}

void Menu_SelectPrev()
{
	if(menuindex>0)
	 {
	  menuindex--;
	  if(menuindex<menufirstpos) menufirstpos--;
     } else
	 {
	  const struct _menuitem *tmpmenuitem=currMenuPtr;
	  while(tmpmenuitem)
	  {
	   tmpmenuitem=GetAddr(tmpmenuitem,next);
       if(tmpmenuitem) menuindex++;
	  }
	  menufirstpos=menuindex-1;
	  if(menufirstpos<0) menufirstpos=0;
     }
	Menu_Show();
}

void Menu_Back()
{
	const struct _menuitem *tmpMenuPtr=GetAddr(currMenuPtr, parent);
	menufirstpos=0;
	menuindex=0;
	currMenuPtr=tmpMenuPtr;
}

void Menu_Click()
{
	const struct _menuitem *tmpmenuitem=GetMenuItem(menuindex);
	const struct _menuitem *submenu=GetAddr(tmpmenuitem, submenu);

    menuitemfuncptr mfptr=GetAddr(tmpmenuitem, menuitemfunc);
	if(mfptr) (*mfptr)();
	if(submenu) 
	 {
	  currMenuPtr=submenu;
	  menuindex=0;
	  menufirstpos=0;
     }
    Menu_Show();
}
