/*
 * GetFuses.c
 *
 * Created: 2012-05-20 14:52:49
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <nvm.h>

NVM_PROD_SIGNATURES_t prod_sig;
uint8_t user_sig[USER_SIGNATURES_SIZE];
NVM_FUSES_t Fuses;

int main(void)
{
	for(uint8_t i=0; i<sizeof(Fuses); i++)                                   //Odczytaj fusebity
	    ((uint8_t*)&Fuses)[i]=nvm_fuses_read(i);
		
	for(uint8_t i=0; i<sizeof(NVM_PROD_SIGNATURES_t); i++)                   //Odczytaj sygnatur produkcyjn procesora
	    ((uint8_t*)&prod_sig)[i]=nvm_read_production_signature_row(i);
	
	DACA_GAINCAL=prod_sig.DACAGAINCAL;
	DACA_OFFSETCAL=prod_sig.DACAOFFCAL;
	DACB_GAINCAL=prod_sig.DACBGAINCAL;
	DACB_OFFSETCAL=prod_sig.DACBOFFCAL;
	
	ADCA.CALL=nvm_read_production_signature_row(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0)); //Odcztaj bajty kalibracyjne ADC
	ADCA.CALH=nvm_read_production_signature_row(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));
	
	for(uint16_t i=0; i<sizeof(NVM_PROD_SIGNATURES_t); i++)                   //Odczytaj sygnatur uytkownika procesora
	    user_sig[i]=nvm_read_user_signature_row(i);
	
    while(1) {} //Nic nie robimy
}