/*
 * DAC1.c
 *
 * Created: 2012-03-22 22:51:01
 *  Author: tmf
 */ 


#include <avr/io.h>

uint16_t wave[] ={0,4096>>4, 8192>>4, 12288>>4, 16384>>4, 20480>>4, 24576>>4, 28672>>4, 32768>>4, 36863>>4, 40959>>4, 45055>>4, 49151>>4, 53247>>4, 57343>>4,      //32 prbki
	61439>>4, 57343>>4, 53247>>4, 49151>>4, 45055>>4, 40959>>4, 36863>>4, 32768>>4, 28672>>4, 24576>>4, 20480>>4, 16384>>4, 12288>>4, 8192>>4, 4096>>4};

void DAC_init()
{
	DACA.CTRLC=DAC_REFSEL_INT1V_gc;          //Wewn. napicie ref. 1 V
	DACA.TIMCTRL=DAC_CONINTVAL_16CLK_gc;     //CLK/4
	DACA.CTRLB=DAC_CH0TRIG_bm;               //Konwersja wyzwalana zdarzeniem
	DACA.EVCTRL=DAC_EVSEL_0_gc;              //EvCh 0
	EVSYS_CH0MUX=EVSYS_CHMUX_PRESCALER_1_gc; //taktowanie evch0 z CLKPer
	DACA.CTRLA=DAC_ENABLE_bm | DAC_CH0EN_bm; //Wcz DAC, kana 0 routowany na IO (PA2)
}

void DMA_init()
{
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez double buffering
	
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok, adres docelowy co paczk
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_DACA_CH0_gc; //Zdarzeniem wyzwalajcym jest pusty rejestr danych kanau CH0 DACA
	DMA.CH0.TRFCNT=sizeof(wave);                //Blok ma dugo tablicy prbek
	DMA.CH0.REPCNT=0;                           //Transfer bdzie pwtarzany w nieskoczono
	DMA.CH0.SRCADDR0=(uint16_t)&wave & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&wave >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica wave
	DMA.CH0.DESTADDR0=(uint16_t)(&DACA.CH0DATA) & 0xFF; //Dane wpisujemy do rejestru DATA ukadu DAC
	DMA.CH0.DESTADDR1=(uint16_t)(&DACA.CH0DATA) >> 8;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_2BYTE_gc | DMA_CH_SINGLE_bm;  //Kana 0 w trybie powtarzania, dugo transferu 2 bajty, single shot	
}

int main(void)
{
	DMA_init();
	DAC_init();
	
    while(1) {}
}