/*
 * ADV.c
 *
 * Created: 2013-08-08 18:05:59
 *  Author: tmf
 */

#include "ADV/ADV.h"
#include "ADV/ADVFunc.h"
#include <avr/pgmspace.h>
#include <asf.h>
#include "AT45IO.h"
#include "AT45CMD.h"
#include "ADC.h"

typedef struct                        //Typ pakietu - 0x04 - Field-configuration
{
    ADV_base;
	uint8_t  Stream_number;           //Numer strumienia
	uint32_t Timestamp;               //Marker czasowy
	int32_t Data[3];                  //Miejsce na dane dla kanaw 0-2
	ADV_End;
} ADV_Data_int3_pkt_t;

void USB_send_block_F(const uint8_t *block, uint8_t size);  //Wylij blok danych z pamici FLASH przez USB

const ADV_Start_cfg_t cfg_start PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Start_cfg_t), ADV_PKT_CONFIG_START}, 1, {0, 0x06}};
const ADV_Stream_cfg_t cfg_stream PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Stream_cfg_t), ADV_PKT_CONFIG_STREAM}, 1, 1000000UL, 3, "Pomiar", {0, 0x06}};
const ADV_Data_cfg_t cfg_Data1 PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Data_cfg_t), ADV_PKT_CONFIG_FIELD}, 1, 1, 4, FIELD_FORMAT_SIGNED, 0, 1000, "mV", "CH0", {0, 0x06}};
const ADV_Data_cfg_t cfg_Data2 PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Data_cfg_t), ADV_PKT_CONFIG_FIELD}, 1, 2, 4, FIELD_FORMAT_SIGNED, 0, 1000, "mV", "CH1", {0, 0x06}};
const ADV_Data_cfg_t cfg_Data3 PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_Data_cfg_t), ADV_PKT_CONFIG_FIELD}, 1, 3, 4, FIELD_FORMAT_SIGNED, 0, 1000, "mV", "CH2", {0, 0x06}};
const ADV_End_cfg_t cfg_End PROGMEM = {{ADV_PKT_HEADER, sizeof(ADV_End_cfg_t), ADV_PKT_CONFIG_END}, 1, {0, 0x06}};

void ADV_init()
{
	USB_send_block_F((uint8_t*)&cfg_start, sizeof(ADV_Start_cfg_t));   //Wylij konfiguracj
	USB_send_block_F((uint8_t*)&cfg_stream, sizeof(ADV_Stream_cfg_t)); //Wylij konfiguracj strumienia
	USB_send_block_F((uint8_t*)&cfg_Data1, sizeof(ADV_Data_cfg_t));     //Wylij konfiguracj danych strumienia
	USB_send_block_F((uint8_t*)&cfg_Data2, sizeof(ADV_Data_cfg_t));
	USB_send_block_F((uint8_t*)&cfg_Data3, sizeof(ADV_Data_cfg_t));
	USB_send_block_F((uint8_t*)&cfg_End, sizeof(ADV_End_cfg_t));       //Koniec konfiguracji
}

void SendDataToADV()
{
	ADV_init();

	ADV_Data_int3_pkt_t ADV_Data = {{ADV_PKT_HEADER, sizeof(ADV_Data_int3_pkt_t), ADV_PKT_DATA}, 1, 0, .Data[0]=0, .Data[1]=0, .Data[2]=0, {0, 0x06}}; //Struktura zawierajca pakiet danych dla ADV
	uint8_t Bufor[DataFLASH_PageSize];
	__uint24 Adres=0;  //Adres w pamici DataFLASH
	DataLogger_t *dl;
	uint16_t Offset=0;
	_Bool koniec=false;

	uint8_t TimerClk=TCC0.CTRLA; //Zachowaj stan zegara timera
	TCC0.CTRLA=TC_CLKSEL_OFF_gc; //Wycz akwizycj danych na czas ich wysyania do PC
	DataFLASH_WaitForBusy();     //Zaczekaj na gotowo pamici

	do
	{
		DataFLASH_ReadSeq(Adres, Bufor, DataFLASH_PageSize); //Odczytaj stron pamici
		Adres+=DataFLASH_PageSize;
		while(Offset<DataFLASH_PageSize)
		{
			dl=(DataLogger_t*)&Bufor[Offset];
			Offset+=sizeof(DataLogger_t);
			if(dl->Timestamp == (uint32_t)-1)
			{
				koniec=true;   //Koniec danych
				break; //Zakocz ptl
			}
			ADV_Data.Timestamp=dl->Timestamp;
			for(uint8_t i=0; i < 3; i++) ADV_Data.Data[i]=dl->CH[i];
			udi_cdc_write_buf(&ADV_Data, sizeof(ADV_Data_int3_pkt_t)); //Wylij dane
		}
		Offset=0;
	} while(!koniec);

	TCC0.CTRLA=TimerClk;         //Odtwrz zegar timera
}

void USB_send_block_F(const uint8_t *block, uint8_t size)
{
	while(size--)
	{
		udi_cdc_putc(pgm_read_byte(block));
		++block;
	}
}
