/*
 * SDRAM.h
 *
 * Created: 2013-10-12 22:06:06
 *  Author: tmf
 */


#ifndef SDRAM_H_
#define SDRAM_H_

#include <stdint.h>
#include <avr/io.h>

void SDRAM_init();  //Inicjalizacja kontrolera SDRAM

static inline void hugemem_write8(__uint24 addr, uint8_t val)
{
	asm volatile(
	"in __tmp_reg__, %2" "\n\t"
	"movw r30, %A0 \n\t"
	"out %2, %C0 \n\t"
	"st Z, %1 \n\t"
	"out %2, __tmp_reg__"
	:
	: "r"(addr), "r"(val), "i"(&RAMPZ)
	: "r30", "r31"
	);
}

static inline uint8_t hugemem_read8(const __uint24 addr)
{
	uint8_t value;

	asm volatile(
	"in __tmp_reg__, %2" "\n\t"
	"movw r30, %A1 \n\t"
	"out %2, %C1 \n\t"
	"ld %0, Z \n\t"
	"out %2, __tmp_reg__"
	: "=r"(value)
	: "r"(addr), "i"(&RAMPZ)
	: "r30", "r31"
	);

	return value;
}

#endif /* SDRAM_H_ */