/*
 * PWM_DMA.c
 *
 * Created: 2012-03-18 10:58:18
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdbool.h>
#include <util/delay.h>
#include <avr/interrupt.h>

//uint16_t wave[] ={0, 8192, 16384, 24576, 32768, 40959, 49151, 57343, 65535, 49151, 40959, 32768, 24576, 16384, 8192};  //15 prbek
uint16_t wave[] ={0,4096, 8192, 12288, 16384, 20480, 24576, 28672, 32768, 36863, 40959, 45055, 49151, 53247, 57343,      //32 prbki
	61439, 57343, 53247, 49151, 45055, 40959, 36863, 32768, 28672, 24576, 20480, 16384, 12288, 8192, 4096};

void Timer_init()
{
	PORTC.DIRSET=0b0000001;       //PD0 jest wyjciem OC0A
	TCC0.CTRLB=TC0_CCAEN_bm | TC_WGMODE_SS_gc;       //Odblokuj rejestr compare A, tryb single slope
	TCC0.PER=0xffff;                //16-bitowy PWM
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;  //Preskaler 1
}

void DMA_init()
{
	DMA.CTRL=DMA_ENABLE_bm;  //Odblokuj kontroler DMA, round robin, bez bouble buffering
	
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc; //Zwiekszamy adres rda i przeznaczenia, reload adresu co blok, adres docelowy co paczk
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_TCC0_CCA_gc; //Zdarzeniem wyzwalajcym jest event match dla CCA
	DMA.CH0.TRFCNT=sizeof(wave);                //Blok ma dugo tablicy prbek
	DMA.CH0.REPCNT=0;                           //Transfer bdzie pwtarzany w nieskoczono
	DMA.CH0.SRCADDR0=(uint16_t)&wave & 0xFF;
	DMA.CH0.SRCADDR1=(uint16_t)&wave >>8;
	DMA.CH0.SRCADDR2=0;                        //rdem danych jest tablica wave
	DMA.CH0.DESTADDR0=(uint16_t)(&TCC0.CCABUF) & 0xFF;
	DMA.CH0.DESTADDR1=(uint16_t)(&TCC0.CCABUF) >> 8;
	DMA.CH0.DESTADDR2=0;                       //Dane bd przesyane do rejestru CCABUF timera TC0
	DMA.CH0.CTRLA=DMA_CH_ENABLE_bm | DMA_CH_REPEAT_bm | DMA_CH_BURSTLEN_2BYTE_gc | DMA_CH_SINGLE_bm;  //Kana 0 w trybie powtarzania, dugo transferu 2 bajty, single shot
}

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	 _delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	return OSC_wait_for_rdy(OSC_RC32MEN_bm); //Zaczekaj na jego poprawny start
}

int main(void)
{
	RC32M_en();   //Timer musi by taktowany jak najszybciej - 32 MHz
	
	CCP=CCP_IOREG_gc;
	CLK_CTRL=CLK_SCLKSEL_RC32M_gc;   //Przecz rdo zegara CPU
	
	Timer_init();
	DMA_init();
	
    while(1) {}
}