/*
 * HiRes8.c
 *
 * Created: 2013-03-02 12:20:04
 *  Author: tmf
 */ 


#include <avr/io.h>
#include "ClkSources.h"

void Clk_init()
{
	RC32M_en();
	SelectPLL(OSC_PLLSRC_RC32M_gc, 16);
	
	CCP=CCP_IOREG_gc;              //Odblokuj moliwo zmiany
	CLK_PSCTRL=CLK_PSADIV_1_gc | CLK_PSBCDIV_2_2_gc;  //CLKper4=PLL, CLKper2=PLL/2, CLKio=PLL/4
	CCP=CCP_IOREG_gc;              //Odblokuj moliwo zmiany
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;   //Wybierz jako rdo zegara PLL
}

void HiRes_init()
{
	HIRESC_CTRLA=HIRES_HREN_TC0_gc;  //Odblokuj rozszerzenie HiRes dla TC0
	PORTC_DIR=255;  //piny 0-7 to wyjcia PWM
	TCC0.CTRLE=TC_BYTEM_SPLITMODE_gc; //Podziel licznik na 2 timery typu 2
	TCC0.PER=0xfcfc;                //PERL i PERH maj okres 0xFC
	TCC0.CTRLB=0xff;                //Odblokowujemy wszystkie kanay PWM
	TCC0.CCA=0x2010;
	TCC0.CCB=0x4030;
	TCC0.CCC=0x6050;
	TCC0.CCD=0x8070;
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;
}

int main(void)
{
	Clk_init();
	HiRes_init();

    while(1)
    {
        //TODO:: Please write your application code 
    }
}