/*
 * usart_planista.c
 *
 * Created: 2013-01-27 13:43:53
 *  Author: tmf
 */


#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include "usart.h"
#include "bufusart.h"
#include "DMA.h"

ISR(TCC0_OVF_vect)
{
	USART_send_buf_F(&sendBuf, PSTR("Witam w przerwaniu\r\n"));
}

void USART_init()
{
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;                          //Pin TxD musi by wyjciem
	USARTC0.CTRLA=USART_RXCINTLVL_LO_gc;           //Odblokuj przerwania odbiornika i nadajnika
	PMIC_CTRL|=PMIC_LOLVLEN_bm;                    //Odblokuj przerwanie niskiego poziomu
	USARTC0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;   //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;            //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);     //Szybko transmisji
	DMA_init();                                    //Zainicjuj DMA dla nadajnika USARTC0
}

void Timer_init()
{
	TCC0.PER=15625;                     //Ok. 2 przerwania ovf/sekund dla f=2MHz
	TCC0.INTCTRLA=TC_OVFINTLVL_LO_gc;   //Przerwanie nadmiaru
	PMIC_CTRL|=PMIC_LOLVLEN_bm;
	TCC0.CTRLA=TC_CLKSEL_DIV64_gc;
}

int main(void)
{
	USART_init();
	Timer_init();
	sei();

	while(1)
	{
		USART_send_buf_F(&sendBuf, PSTR("Witam w aplikacji\r\n"));
		_delay_ms(1000);
	}
}