/*
 * DCF77Demo.c
 *
 * Created: 2012-03-07 17:20:13
 *  Author: tmf
 */ 

#include <avr/io.h>
#include "RTC.h"
#include "DCF77.h"
#include <avr/interrupt.h>
#include <util/delay.h>
#include <calendar.h>
#include "LCD/LCD.h"
#include "LCD/hd44780.h"
#include <stdio.h>
#include <util/delay.h>


struct calendar_date dt={0, 0, 0, 0, 0, 2012};  //1 stycznia 2012, godzina 0:00

int main(void)
{
	char buf[21];        //Bufor do konwersji czasu
	
	RTC_init();          //Zainicjuj ukad RTC	
	DCF77_Rec_Init();    //Zainicjuj modu DCF77
	lcd_init();          //Zainicjuj wywietlacz LCD
 
	SetTimestamp(calendar_date_to_timestamp(&dt));  //Zamie dat na EPOCH
	TimestampUpdate=true;    //Jeli bdzie okazja to uaktualnij czas na podstawie danych z DCF77
	
	sei();
	
    while(1)
    {
		calendar_timestamp_to_date(GetTimestamp(), &dt);  //Konwersja EPOCH na normalny zapis daty
		lcd_home();
		sprintf(buf, "%02u:%02u:%02u \n%2u/%02u/%4u", dt.hour, dt.minute, dt.second, dt.date+1, dt.month+1, dt.year);      //Wywietl czas i dat
		lcd_puttext(buf);
		_delay_ms(1000);
		if(TimestampUpdate==0)
		{
			TimestampUpdate=1;
		}			
    }
}
