/*
 * ClkSources.c
 *
 * Created: 2012-03-04 19:30:52
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/delay.h>
#include <stdbool.h>

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	 _delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RS32k_en()
{
	OSC.CTRL |= OSC_RC32KEN_bm;  //Wcz generator 32k ULP
	return OSC_wait_for_rdy(OSC_RC32KEN_bm); //Zaczekaj na jego poprawny start
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	return OSC_wait_for_rdy(OSC_RC32MEN_bm); //Zaczekaj na jego poprawny start
}

bool RC2M_en()
{
	OSC.CTRL |= OSC_RC2MEN_bm; //Wcz generator RC 32 MHz
	return OSC_wait_for_rdy(OSC_RC2MEN_bm); //Zaczekaj na jego poprawny start	
}

bool XTAL_en()
{
	OSC.XOSCCTRL |= OSC_FRQRANGE_12TO16_gc | OSC_XOSCSEL_XTAL_16KCLK_gc; //Wybr typu kwarcu
	OSC.CTRL |= OSC_XOSCEN_bm; //Wcz zewntrzny generator kwarcowy
	return OSC_wait_for_rdy(OSC_XOSCEN_bm); //Zaczekaj na jego poprawny start
}

bool XTAL32k_en()
{
	OSC.XOSCCTRL = OSC_XOSCSEL_32KHz_gc | OSC_X32KLPM_bm; //Wybierz kwarc zegarkowy i tryb niskiej mocy
	OSC.CTRL |= OSC_XOSCEN_bm; //Wcz zewntrzny generator kwarcowy
	return OSC_wait_for_rdy(OSC_XOSCEN_bm); //Zaczekaj na jego poprawny start	
}

void SelectPLL(OSC_PLLSRC_t src, uint8_t mult)
{
	mult&=OSC_PLLFAC_gm;
	OSC.PLLCTRL=src | mult;              //Ustaw rdo i mnonik PLL
	OSC.CTRL|=OSC_PLLEN_bm;				 //Wcz ukad PLL
	OSC_wait_for_rdy(OSC_PLLRDY_bm);     //Poczekaj na ustabilizowanie si PLL
}

void RC32M_DFLL_en()
{
	RC32M_en();                              //Wcz generator RC 32 MHz
	XTAL32k_en();                            //Wcz generator kwarcowy 32768 Hz
	OSC.DFLLCTRL|=OSC_RC32MCREF_bm;          //DFLL bdzie uywa jako wzorca zewntrznego kwarcu 32768 Hz
    DFLLRC32M_CTRL=DFLL_ENABLE_bm;           //Odblokuj ukad DFLL
}

void RC2M_DFLL_en()
{
	RC2M_en();                               //Wcz generator RC 32 MHz
	XTAL32k_en();                            //Wcz generator kwarcowy 32768 Hz
	OSC.DFLLCTRL|=OSC_RC2MCREF_bm;           //DFLL bdzie uywa jako wzorca zewntrznego kwarcu 32768 Hz
    DFLLRC2M_CTRL=DFLL_ENABLE_bm;            //Odblokuj ukad DFLL	
}

int main(void)
{
	//RC2M_en();
	RC2M_DFLL_en();           //Wcz DFLL dla generatora 2 MHz
	RC32M_DFLL_en();          //Wcz DFLL dla generatora 32 MHz
	SelectPLL(OSC_PLLSRC_RC2M_gc, 15);
    while(1)
    {
        //TODO:: Please write your application code 
    }
}