/*
 * EEPROMToken.h
 *
 * Created: 2012-09-16 15:59:20
 *  Author: tmf
 */ 


#ifndef EEPROMTOKEN_H_
#define EEPROMTOKEN_H_

#include <stdint.h>
#include <stdbool.h>
#include <avr/io.h>

static inline void EEPROMReg_Init()  //Zainicjuj obsug pamici
 {
	while(NVM.STATUS & NVM_NVMBUSY_bm); //Zaczekaj na koniec poprzednich operacji NVM
	NVM_CTRLB|=NVM_EEMAPEN_bm;          //Zmapuj EEPROM w obszar RAM, co uproci odwoania do pamici
 }
 
bool EEPROMReg_AddRegEntry(const char *regname, void *regvalue, uint8_t size); //Dodaj/utwrz nowy rekord
void *EEPROMReg_GetRegEntry(const char *regname, uint8_t *size); //Zwraca adres pola danych wskazanego rekordu
void EEPROMReg_DelRegEntry(const char *regname);  //Skasuj rekord

#endif /* EEPROMTOKEN_H_ */